/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.any23.cli.Tool;
import org.apache.any23.extractor.ExtractorFactory;
import org.apache.any23.mime.MIMEType;
import org.apache.any23.plugin.Any23PluginManager;
import org.apache.any23.plugin.Author;

@Parameters(commandNames={"verify"}, commandDescription="Utility for plugin management verification.")
public class PluginVerifier
implements Tool {
    private Any23PluginManager pluginManager = Any23PluginManager.getInstance();
    @Parameter(description="plugins-dir", converter=FileConverter.class)
    private List<File> pluginsDirs = new LinkedList<File>();

    public void run() throws Exception {
        if (this.pluginsDirs.isEmpty()) {
            throw new IllegalArgumentException("No plugin directory specified.");
        }
        File pluginsDir = this.pluginsDirs.get(0);
        if (!pluginsDir.isDirectory()) {
            throw new IllegalArgumentException("<plugins-dir> must be a valid dir.");
        }
        this.pluginManager.loadJARDir(pluginsDir);
        Iterator plugins = this.pluginManager.getExtractors();
        while (plugins.hasNext()) {
            this.printPluginData((ExtractorFactory)plugins.next(), System.out);
            System.out.println("------------------------------------------------------------------------");
        }
    }

    private String getMimeTypesStr(Collection<MIMEType> mimeTypes) {
        StringBuilder sb = new StringBuilder();
        for (MIMEType mt : mimeTypes) {
            sb.append(mt).append(' ');
        }
        return sb.toString();
    }

    private void printPluginData(ExtractorFactory extractorFactory, PrintStream ps) {
        Author authorAnnotation = extractorFactory.getClass().getAnnotation(Author.class);
        ps.printf("Plugin author    : %s%n", authorAnnotation == null ? "<unknown>" : authorAnnotation.name());
        ps.printf("Plugin factory   : %s%n", extractorFactory.getClass());
        ps.printf("Plugin mime-types: %s%n", this.getMimeTypesStr(extractorFactory.getSupportedMIMETypes()));
    }
}

