/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;

final class OperationMethodSet
extends AbstractSet<OperationMethod> {
    private final Class<? extends SingleOperation> type;
    private final Iterable<? extends OperationMethod> methods;
    private Iterator<? extends OperationMethod> methodIterator;
    private final List<OperationMethod> cachedMethods;

    OperationMethodSet(Class<? extends SingleOperation> clazz, Iterable<? extends OperationMethod> iterable) {
        this.type = clazz;
        this.methods = iterable;
        this.cachedMethods = new ArrayList<OperationMethod>();
        this.reset();
    }

    final synchronized void reset() {
        assert (Thread.holdsLock(this.methods));
        this.cachedMethods.clear();
        this.methodIterator = this.methods.iterator();
        if (!this.methodIterator.hasNext()) {
            this.methodIterator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transfer() {
        OperationMethod operationMethod;
        assert (Thread.holdsLock(this));
        Object object = this.methods;
        synchronized (object) {
            operationMethod = this.methodIterator.next();
            if (!this.methodIterator.hasNext()) {
                this.methodIterator = null;
            }
        }
        if (operationMethod instanceof DefaultOperationMethod && (object = ((DefaultOperationMethod)operationMethod).getOperationType()) != null && !this.type.isAssignableFrom((Class<?>)object)) {
            return false;
        }
        if (!(this.methods instanceof ServiceLoader) && !(this.methods instanceof Set) && this.cachedMethods.contains(operationMethod)) {
            return false;
        }
        return this.cachedMethods.add(operationMethod);
    }

    @Override
    public synchronized boolean isEmpty() {
        if (!this.cachedMethods.isEmpty()) {
            return false;
        }
        while (this.methodIterator != null) {
            if (!this.transfer()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized int size() {
        while (this.methodIterator != null) {
            this.transfer();
        }
        return this.cachedMethods.size();
    }

    final synchronized boolean hasNext(int n) {
        if (n >= this.cachedMethods.size()) {
            do {
                if (this.methodIterator != null) continue;
                return false;
            } while (!this.transfer());
        }
        return true;
    }

    final synchronized OperationMethod next(int n) {
        if (n >= this.cachedMethods.size()) {
            do {
                if (this.methodIterator != null) continue;
                throw new NoSuchElementException();
            } while (!this.transfer());
        }
        return this.cachedMethods.get(n);
    }

    @Override
    public Iterator<OperationMethod> iterator() {
        return new Iterator<OperationMethod>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return OperationMethodSet.this.hasNext(this.cursor);
            }

            @Override
            public OperationMethod next() {
                return OperationMethodSet.this.next(this.cursor++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean contains(Object object) {
        Class<? extends SingleOperation> clazz;
        if (object instanceof DefaultOperationMethod ? (clazz = ((DefaultOperationMethod)object).getOperationType()) != null && !this.type.isAssignableFrom(clazz) : !(object instanceof OperationMethod)) {
            return false;
        }
        return super.contains(object);
    }
}

