/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

final class UnmodifiableMatrix
extends MatrixSIS {
    private static final long serialVersionUID = 7239828819464047564L;
    private final Matrix matrix;

    UnmodifiableMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    @Override
    public int getNumRow() {
        return this.matrix.getNumRow();
    }

    @Override
    public int getNumCol() {
        return this.matrix.getNumCol();
    }

    @Override
    public boolean isIdentity() {
        return this.matrix.isIdentity();
    }

    @Override
    public double getElement(int n, int n2) {
        return this.matrix.getElement(n, n2);
    }

    @Override
    public double[] getElements() {
        if (this.matrix instanceof MatrixSIS) {
            return ((MatrixSIS)this.matrix).getElements();
        }
        return super.getElements();
    }

    private UnsupportedOperationException canNotModify() {
        return new UnsupportedOperationException(Errors.format((short)123, this.getClass()));
    }

    @Override
    public void setElements(double[] dArray) {
        throw this.canNotModify();
    }

    @Override
    public void setElement(int n, int n2, double d) {
        throw this.canNotModify();
    }

    @Override
    public void transpose() {
        throw this.canNotModify();
    }

    @Override
    public MatrixSIS clone() {
        return UnmodifiableMatrix.castOrCopy(this.matrix.clone());
    }
}

