/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.writer.FormatWriter;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleHandlerException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;

public abstract class RDFWriterTripleHandler
implements FormatWriter,
TripleHandler {
    private final RDFWriter writer;
    private boolean closed = false;
    private boolean annotated = false;

    RDFWriterTripleHandler(RDFWriter destination) {
        this.writer = destination;
        try {
            this.writer.startRDF();
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public void setAnnotated(boolean f) {
        this.annotated = f;
    }

    public void startDocument(IRI documentIRI) throws TripleHandlerException {
        this.handleComment("OUTPUT FORMAT: " + this.writer.getRDFFormat());
    }

    public void openContext(ExtractionContext context) throws TripleHandlerException {
        this.handleComment("BEGIN: " + context);
    }

    public void receiveTriple(Resource s, IRI p, Value o, IRI g, ExtractionContext context) throws TripleHandlerException {
        IRI graph = g == null ? context.getDocumentIRI() : g;
        try {
            this.writer.handleStatement(RDFUtils.quad(s, p, o, (Resource)graph));
        }
        catch (RDFHandlerException ex) {
            throw new TripleHandlerException(String.format("Error while receiving triple: %s %s %s %s", s, p, o, graph), (Exception)((Object)ex));
        }
    }

    public void receiveNamespace(String prefix, String uri, ExtractionContext context) throws TripleHandlerException {
        try {
            this.writer.handleNamespace(prefix, uri);
        }
        catch (RDFHandlerException ex) {
            throw new TripleHandlerException(String.format("Error while receiving namespace: %s:%s", prefix, uri), (Exception)((Object)ex));
        }
    }

    public void closeContext(ExtractionContext context) throws TripleHandlerException {
        this.handleComment("END: " + context);
    }

    public void close() throws TripleHandlerException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.writer.endRDF();
        }
        catch (RDFHandlerException e) {
            throw new TripleHandlerException("Error while closing the triple handler.", (Exception)((Object)e));
        }
    }

    public void endDocument(IRI documentIRI) throws TripleHandlerException {
    }

    public void setContentLength(long contentLength) {
    }

    private void handleComment(String comment) throws TripleHandlerException {
        if (!this.annotated) {
            return;
        }
        try {
            this.writer.handleComment(comment);
        }
        catch (RDFHandlerException rdfhe) {
            throw new TripleHandlerException("Error while handing comment.", (Exception)((Object)rdfhe));
        }
    }
}

