/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Optional;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.writer.FormatWriter;
import org.apache.any23.writer.TripleHandlerException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class JSONWriter
implements FormatWriter {
    private final PrintStream ps;
    private boolean documentStarted = false;
    private boolean firstArrayElemWritten = false;
    private boolean firstObjectWritten = false;

    public JSONWriter(OutputStream os) {
        if (os == null) {
            throw new NullPointerException("Output stream cannot be null.");
        }
        this.ps = new PrintStream(new BufferedOutputStream(os));
    }

    public void startDocument(IRI documentIRI) throws TripleHandlerException {
        if (this.documentStarted) {
            throw new IllegalStateException("Document already started.");
        }
        this.documentStarted = true;
        this.firstArrayElemWritten = false;
        this.ps.print("{ \"quads\" : [");
    }

    public void openContext(ExtractionContext context) throws TripleHandlerException {
    }

    public void receiveTriple(Resource s, IRI p, Value o, IRI g, ExtractionContext context) throws TripleHandlerException {
        this.validateDocumentStarted();
        if (this.firstArrayElemWritten) {
            this.ps.print(", ");
        } else {
            this.firstArrayElemWritten = true;
        }
        this.firstObjectWritten = false;
        this.ps.print('[');
        if (s instanceof IRI) {
            this.printExplicitIRI(s.stringValue(), this.ps);
        } else {
            this.printBNode(s.stringValue(), this.ps);
        }
        this.printIRI(p.stringValue(), this.ps);
        if (o instanceof IRI) {
            this.printExplicitIRI(o.stringValue(), this.ps);
        } else if (o instanceof BNode) {
            this.printBNode(o.stringValue(), this.ps);
        } else {
            this.printLiteral((Literal)o, this.ps);
        }
        this.printIRI(g == null ? null : g.stringValue(), this.ps);
        this.ps.print(']');
    }

    public void receiveNamespace(String prefix, String uri, ExtractionContext context) throws TripleHandlerException {
    }

    public void closeContext(ExtractionContext context) throws TripleHandlerException {
    }

    public void endDocument(IRI documentIRI) throws TripleHandlerException {
        this.validateDocumentStarted();
        this.ps.print("]}");
        this.documentStarted = false;
    }

    public void setContentLength(long contentLength) {
    }

    public void close() throws TripleHandlerException {
        if (this.documentStarted) {
            this.endDocument(null);
        }
        this.ps.close();
    }

    private void validateDocumentStarted() {
        if (!this.documentStarted) {
            throw new IllegalStateException("Document didn't start.");
        }
    }

    private void printIRI(String uri, PrintStream ps) {
        this.printValue(uri, ps);
    }

    private void printExplicitIRI(String uri, PrintStream ps) {
        this.printValue("uri", uri, ps);
    }

    private void printBNode(String bnode, PrintStream ps) {
        this.printValue("bnode", bnode, ps);
    }

    private void printCommaIfNeeded(PrintStream ps) {
        if (this.firstObjectWritten) {
            ps.print(", ");
        } else {
            this.firstObjectWritten = true;
        }
    }

    private void printLiteral(Literal literal, PrintStream ps) {
        this.printCommaIfNeeded(ps);
        ps.print('{');
        ps.print("\"type\" : \"literal\"");
        ps.print(", ");
        ps.print("\"value\" : ");
        ps.print('\"');
        ps.print(literal.stringValue());
        ps.print('\"');
        ps.print(", ");
        ps.print("\"lang\" : ");
        Optional language = literal.getLanguage();
        if (language.isPresent()) {
            ps.print('\"');
            ps.print((String)literal.getLanguage().get());
            ps.print('\"');
        } else {
            ps.print("null");
        }
        ps.print(", ");
        ps.print("\"datatype\" : ");
        IRI datatype = literal.getDatatype();
        if (datatype != null) {
            ps.print('\"');
            ps.print(datatype.stringValue());
            ps.print('\"');
        } else {
            ps.print("null");
        }
        ps.print('}');
    }

    private void printValue(String type, String value, PrintStream ps) {
        this.printCommaIfNeeded(ps);
        ps.print("{ \"type\" : \"");
        ps.print(type);
        ps.print("\", \"value\" : ");
        if (value != null) {
            ps.print('\"');
            ps.print(value);
            ps.print('\"');
        } else {
            ps.print("null");
        }
        ps.print('}');
    }

    private void printValue(String value, PrintStream ps) {
        this.printCommaIfNeeded(ps);
        if (value != null) {
            ps.print('\"');
            ps.print(value);
            ps.print('\"');
        } else {
            ps.print("null");
        }
    }

    public boolean isAnnotated() {
        return false;
    }

    public void setAnnotated(boolean f) {
    }
}

