/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.any23.mime.MIMEType;

public class AcceptHeaderBuilder {
    private Collection<MIMEType> mimeTypes;
    private MIMEType highestAnyType = null;
    private Map<String, MIMEType> highestAnySubtype = new HashMap<String, MIMEType>();
    private Map<String, MIMEType> highestSpecificType = new HashMap<String, MIMEType>();

    public static AcceptHeaderBuilder fromStrings(Collection<String> typesAsStrings) {
        ArrayList<MIMEType> types = new ArrayList<MIMEType>(typesAsStrings.size());
        for (String type : typesAsStrings) {
            types.add(MIMEType.parse((String)type));
        }
        return new AcceptHeaderBuilder(types);
    }

    public AcceptHeaderBuilder(Collection<MIMEType> mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public String getAcceptHeader() {
        if (this.mimeTypes.isEmpty()) {
            return null;
        }
        for (MIMEType mimeType : this.mimeTypes) {
            this.add(mimeType);
        }
        this.removeSpecificTypesCoveredByWildcard();
        this.removeTypesCoveredByWildcard();
        ArrayList<MIMEType> highest = new ArrayList<MIMEType>();
        if (this.highestAnyType != null) {
            highest.add(this.highestAnyType);
        }
        highest.addAll(this.highestAnySubtype.values());
        highest.addAll(this.highestSpecificType.values());
        Collections.sort(highest);
        StringBuffer result = new StringBuffer();
        for (MIMEType a : this.mimeTypes) {
            if (!highest.contains(a)) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(a);
        }
        return result.toString();
    }

    private void add(MIMEType newAccept) {
        if (newAccept.isAnyMajorType()) {
            if (this.highestAnyType == null || newAccept.getQuality() > this.highestAnyType.getQuality()) {
                this.highestAnyType = newAccept;
            }
        } else if (newAccept.isAnySubtype()) {
            if (!this.highestAnySubtype.containsKey(newAccept.getMajorType()) || newAccept.getQuality() > this.highestAnySubtype.get(newAccept.getMajorType()).getQuality()) {
                this.highestAnySubtype.put(newAccept.getMajorType(), newAccept);
            }
        } else if (!this.highestSpecificType.containsKey(newAccept.getFullType()) || newAccept.getQuality() > this.highestSpecificType.get(newAccept.getFullType()).getQuality()) {
            this.highestSpecificType.put(newAccept.getFullType(), newAccept);
        }
    }

    private void removeSpecificTypesCoveredByWildcard() {
        for (MIMEType accept : this.highestSpecificType.values()) {
            if (!this.highestAnySubtype.containsKey(accept.getMajorType()) || !(accept.getQuality() <= this.highestAnySubtype.get(accept.getMajorType()).getQuality())) continue;
            this.highestSpecificType.remove(accept.getFullType());
        }
        if (this.highestAnyType == null) {
            return;
        }
        for (MIMEType accept : this.highestSpecificType.values()) {
            if (!(accept.getQuality() <= this.highestAnyType.getQuality())) continue;
            this.highestSpecificType.remove(accept.getFullType());
        }
    }

    private void removeTypesCoveredByWildcard() {
        if (this.highestAnyType == null) {
            return;
        }
        for (MIMEType accept : this.highestAnySubtype.values()) {
            if (!(accept.getQuality() <= this.highestAnyType.getQuality())) continue;
            this.highestAnySubtype.remove(accept.getMajorType());
        }
    }
}

