/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.yaml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.yaml.ElementsProcessor;
import org.apache.any23.extractor.yaml.YAMLExtractorFactory;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.vocab.YAML;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YAMLExtractor
implements Extractor.ContentExtractor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Yaml yml = new Yaml();
    private static final YAML vocab = YAML.getInstance();
    private final ElementsProcessor ep = ElementsProcessor.getInstance();
    private Resource documentRoot;

    public void setStopAtFirstError(boolean f) {
    }

    public void run(ExtractionParameters extractionParameters, ExtractionContext context, InputStream in, ExtractionResult out) throws IOException, ExtractionException {
        IRI documentIRI = context.getDocumentIRI();
        this.documentRoot = RDFUtils.iri(documentIRI.toString() + "root");
        this.log.debug("Processing: {}", (Object)documentIRI.toString());
        out.writeNamespace("yaml", "http://yaml.org/spec/1.2/spec.html#");
        out.writeNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        out.writeNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        out.writeTriple(this.documentRoot, RDF.TYPE, (Value)YAMLExtractor.vocab.root);
        Iterable docIterate = yml.loadAll(in);
        for (Object p : docIterate) {
            Resource pageNode = RDFUtils.makeIRI("document", documentIRI, true);
            out.writeTriple(this.documentRoot, YAMLExtractor.vocab.contains, (Value)pageNode);
            out.writeTriple(pageNode, RDF.TYPE, (Value)YAMLExtractor.vocab.document);
            ElementsProcessor.ModelHolder rootNode = this.ep.asModel(documentIRI, p, (Value)pageNode);
            if (rootNode == null) continue;
            if (!rootNode.getRoot().equals(pageNode)) {
                out.writeTriple(pageNode, YAMLExtractor.vocab.contains, rootNode.getRoot());
            }
            this.log.debug("Subgraph root node: {}", (Object)rootNode.getRoot().stringValue());
            rootNode.getModel().forEach(s -> out.writeTriple(s.getSubject(), s.getPredicate(), s.getObject()));
        }
    }

    public ExtractorDescription getDescription() {
        return YAMLExtractorFactory.getDescriptionInstance();
    }
}

