/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.xpath;

import java.util.Map;
import org.eclipse.rdf4j.model.Value;

public abstract class Term<T extends Value> {
    private final String internalValue;
    private final boolean isVar;

    protected Term(String internalValue, boolean isVar) {
        this.internalValue = internalValue;
        this.isVar = isVar;
    }

    public String getInternalValue() {
        return this.internalValue;
    }

    public boolean isVar() {
        return this.isVar;
    }

    public T getValue(Map<String, String> varMapping) {
        String value;
        if (this.isVar) {
            value = varMapping.get(this.internalValue);
            if (value == null) {
                throw new IllegalStateException(String.format("Cannot find a valid value for variable '%s'", this.internalValue));
            }
        } else {
            value = this.internalValue;
        }
        return this.getValueInternal(value);
    }

    protected abstract T getValueInternal(String var1);

    public String toString() {
        return this.isVar ? "?" + this.internalValue : this.internalValue;
    }
}

