/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.xpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.xpath.QuadTemplate;
import org.apache.any23.extractor.xpath.TemplateXPathExtractionRule;
import org.apache.any23.extractor.xpath.Variable;
import org.eclipse.rdf4j.model.IRI;
import org.w3c.dom.Document;

public class TemplateXPathExtractionRuleImpl
implements TemplateXPathExtractionRule {
    private final String name;
    private final String uriRegex;
    private final Pattern uriRegexPattern;
    private final List<Variable> variables;
    private final List<QuadTemplate> templates;

    public TemplateXPathExtractionRuleImpl(String name, String uriRegex) {
        if (name == null) {
            throw new NullPointerException("The rule name cannot be null.");
        }
        this.name = name;
        this.uriRegex = uriRegex;
        try {
            this.uriRegexPattern = uriRegex != null ? Pattern.compile(uriRegex) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid value for uriRegex.", e);
        }
        this.variables = new ArrayList<Variable>();
        this.templates = new ArrayList<QuadTemplate>();
    }

    public String getUriRegex() {
        return this.uriRegex;
    }

    @Override
    public void add(Variable variable) {
        this.checkVariableNameNotDeclared(variable.getName());
        this.variables.add(variable);
    }

    @Override
    public boolean remove(Variable variable) {
        return this.variables.remove(variable);
    }

    @Override
    public void add(QuadTemplate template) {
        this.checkTemplateVariablesDeclared(template);
        this.templates.add(template);
    }

    @Override
    public boolean remove(QuadTemplate template) {
        return this.templates.remove(template);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean acceptIRI(IRI uri) {
        if (this.uriRegexPattern == null) {
            return true;
        }
        return this.uriRegexPattern.matcher(uri.stringValue()).find();
    }

    @Override
    public void process(Document in, ExtractionResult er) {
        HashMap<String, String> varValues = new HashMap<String, String>();
        for (Variable variable : this.variables) {
            String value = DomUtils.find(in, variable.getxPath().toUpperCase());
            varValues.put(variable.getName(), value);
        }
        for (QuadTemplate template : this.templates) {
            template.printOut(er, varValues);
        }
    }

    private boolean variableNameDeclared(String varName) {
        for (Variable variable : this.variables) {
            if (!variable.getName().equals(varName)) continue;
            return true;
        }
        return false;
    }

    private void checkVariableNameDeclared(String varName) {
        if (!this.variableNameDeclared(varName)) {
            throw new IllegalArgumentException(String.format("A variable with name '%s' was not declared.", varName));
        }
    }

    private void checkVariableNameNotDeclared(String varName) {
        if (this.variableNameDeclared(varName)) {
            throw new IllegalArgumentException(String.format("A variable with name '%s' is already declared.", varName));
        }
    }

    private void checkTemplateVariablesDeclared(QuadTemplate template) {
        if (template.getSubject().isVar()) {
            this.checkVariableNameDeclared(template.getSubject().getInternalValue());
        }
        if (template.getPredicate().isVar()) {
            this.checkVariableNameDeclared(template.getPredicate().getInternalValue());
        }
        if (template.getObject().isVar()) {
            this.checkVariableNameDeclared(template.getObject().getInternalValue());
        }
        if (template.getGraph() != null && template.getGraph().isVar()) {
            this.checkVariableNameDeclared(template.getGraph().getInternalValue());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("name: ").append(this.name).append('\n');
        sb.append("pattern: '").append(this.uriRegex).append("'").append('\n');
        sb.append("variables {\n");
        for (Variable variable : this.variables) {
            sb.append(variable.getName()).append(":").append(variable.getxPath()).append('\n');
        }
        sb.append("}\n");
        sb.append("templates {\n");
        for (QuadTemplate template : this.templates) {
            sb.append(template).append('\n');
        }
        sb.append("}\n");
        return sb.toString();
    }
}

