/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.microdata;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.any23.extractor.microdata.Item;
import org.apache.any23.extractor.microdata.ItemProp;

public class ItemScope
extends Item {
    private final Map<String, List<ItemProp>> properties;
    private final String id;
    private final String[] refs;
    private final URL type;
    private final String itemId;

    public ItemScope(String xpath, ItemProp[] itemProps, String id, String[] refs, String type, String itemId) {
        super(xpath);
        if (itemProps == null) {
            throw new NullPointerException("itemProps list cannot be null.");
        }
        if (type != null) {
            try {
                this.type = new URL(type);
            }
            catch (MalformedURLException murle) {
                throw new IllegalArgumentException("Invalid type '" + type + "', must be a valid URL.");
            }
        } else {
            this.type = null;
        }
        this.id = id;
        this.refs = refs;
        this.itemId = itemId;
        HashMap<String, ArrayList<ItemProp>> tmpProperties = new HashMap<String, ArrayList<ItemProp>>();
        for (ItemProp itemProp : itemProps) {
            String propName = itemProp.getName();
            ArrayList<ItemProp> propList = (ArrayList<ItemProp>)tmpProperties.get(propName);
            if (propList == null) {
                propList = new ArrayList<ItemProp>();
                tmpProperties.put(propName, propList);
            }
            propList.add(itemProp);
        }
        HashMap<String, List<ItemProp>> properties = new HashMap<String, List<ItemProp>>();
        for (Map.Entry propertiesEntry : tmpProperties.entrySet()) {
            properties.put((String)propertiesEntry.getKey(), (List<ItemProp>)propertiesEntry.getValue());
        }
        this.properties = properties;
    }

    public Map<String, List<ItemProp>> getProperties() {
        return this.properties;
    }

    public String getId() {
        return this.id;
    }

    public String[] getRefs() {
        return this.refs;
    }

    public URL getType() {
        return this.type;
    }

    public String getItemId() {
        return this.itemId;
    }

    @Override
    public String toJSON() {
        StringBuilder sb = new StringBuilder();
        Collection<List<ItemProp>> itemPropsList = this.properties.values();
        int j = 0;
        for (List<ItemProp> itemProps : itemPropsList) {
            int i = 0;
            for (ItemProp itemProp : itemProps) {
                sb.append(itemProp);
                if (i < itemProps.size() - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            if (j < itemPropsList.size() - 1) {
                sb.append(", ");
            }
            ++j;
        }
        return String.format("{ \"xpath\" : \"%s\", \"id\" : %s, \"refs\" : %s, \"type\" : %s, \"itemid\" : %s, \"properties\" : [ %s ] }", this.getXpath(), this.id == null ? null : "\"" + this.id + "\"", this.refs == null ? null : this.toJSON(this.refs), this.type == null ? null : "\"" + this.type + "\"", this.itemId == null ? null : "\"" + this.itemId + "\"", sb.toString());
    }

    public String toString() {
        return this.toJSON();
    }

    @Override
    public int hashCode() {
        int i = this.properties == null ? 0 : this.properties.hashCode();
        i += this.id == null ? 0 : this.id.hashCode();
        i += this.refs == null ? 0 : Arrays.hashCode(this.refs);
        i += this.type == null ? 0 : this.type.hashCode();
        return i += this.itemId == null ? 0 : this.itemId.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ItemScope) {
            ItemScope other = (ItemScope)obj;
            return super.getXpath().equals(other.getXpath()) && (this.properties == null ? other.properties == null : this.properties.equals(other.properties)) && (this.id == null ? other.id == null : this.id.equals(other.id)) && (this.refs == null ? other.refs == null : Arrays.equals(this.refs, other.refs)) && (this.type == null ? other.type == null : this.type.equals(other.type)) && (this.itemId == null ? other.itemId == null : this.itemId.equals(other.itemId));
        }
        return false;
    }

    protected void acquireProperty(ItemProp itemProp) {
        List<ItemProp> itemProps = this.properties.get(itemProp.getName());
        if (itemProps == null) {
            itemProps = new ArrayList<ItemProp>();
            this.properties.put(itemProp.getName(), itemProps);
        }
        if (!itemProps.contains(itemProp)) {
            itemProps.add(itemProp);
        }
    }

    protected void disownProperty(ItemProp itemProp) {
        List<ItemProp> propList = this.properties.get(itemProp.getName());
        if (propList != null) {
            propList.remove(itemProp);
        }
    }

    private String toJSON(String[] in) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < in.length; ++i) {
            sb.append("\"");
            sb.append(in[i]);
            sb.append("\"");
            if (i >= in.length - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }
}

