/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.microdata;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.any23.extractor.microdata.ItemScope;
import org.apache.any23.util.StringUtils;

public class ItemPropValue {
    private final Object content;
    private final Type type;
    private static final ThreadLocal<SimpleDateFormat> sdf = new ThreadLocal();

    public static Date parseDateTime(String dateStr) throws ParseException {
        return ItemPropValue.getSdf().parse(dateStr);
    }

    public static String formatDateTime(Date in) {
        return ItemPropValue.getSdf().format(in);
    }

    private static SimpleDateFormat getSdf() {
        SimpleDateFormat simpleDateFormat = sdf.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            sdf.set(simpleDateFormat);
        }
        return simpleDateFormat;
    }

    public ItemPropValue(Object content, Type type) {
        if (content == null) {
            throw new NullPointerException("content cannot be null.");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null.");
        }
        if (type == Type.Nested && !(content instanceof ItemScope)) {
            throw new IllegalArgumentException("content must be an " + ItemScope.class + " when type is " + (Object)((Object)Type.Nested));
        }
        if (type == Type.Date && !(content instanceof Date)) {
            throw new IllegalArgumentException("content must be a " + Date.class.getName() + " whe type is " + (Object)((Object)Type.Date));
        }
        if (content instanceof String && ((String)content).trim().length() == 0) {
            content = "Null";
        }
        this.content = content;
        this.type = type;
    }

    public Object getContent() {
        return this.content;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isPlain() {
        return this.type == Type.Plain;
    }

    public boolean isLink() {
        return this.type == Type.Link;
    }

    public boolean isDate() {
        return this.type == Type.Date;
    }

    public boolean isNested() {
        return this.type == Type.Nested;
    }

    public boolean isInteger() {
        if (this.type != Type.Plain) {
            return false;
        }
        try {
            Integer.parseInt((String)this.content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isFloat() {
        if (this.type != Type.Plain) {
            return false;
        }
        try {
            Float.parseFloat((String)this.content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isNumber() {
        return this.isInteger() || this.isFloat();
    }

    public int getAsInteger() {
        return Integer.parseInt((String)this.content);
    }

    public float getAsFloat() {
        return Float.parseFloat((String)this.content);
    }

    public Date getAsDate() {
        return (Date)this.content;
    }

    public URL getAsLink() {
        try {
            return new URL((String)this.content);
        }
        catch (MalformedURLException murle) {
            throw new IllegalStateException("Error while parsing IRI.", murle);
        }
    }

    public ItemScope getAsNested() {
        return (ItemScope)this.content;
    }

    public String toJSON() {
        String contentStr = this.content instanceof String ? "\"" + StringUtils.escapeAsJSONString((String)this.content) + "\"" : (this.content instanceof Date ? "\"" + ItemPropValue.getSdf().format((Date)this.content) + "\"" : this.content.toString());
        return String.format("{ \"content\" : %s, \"type\" : \"%s\" }", new Object[]{contentStr, this.type});
    }

    public String toString() {
        return this.toJSON();
    }

    public int hashCode() {
        return this.content.hashCode() * this.type.hashCode() * 2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ItemPropValue) {
            ItemPropValue other = (ItemPropValue)obj;
            return this.content.equals(other.content) && this.type.equals((Object)other.type);
        }
        return false;
    }

    public static enum Type {
        Plain,
        Link,
        Date,
        Nested;

    }
}

