/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html.microformats2;

import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.microformats2.HItemExtractorFactory;
import org.apache.any23.vocab.HItem;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HItemExtractor
extends EntityBasedMicroformatExtractor {
    private static final HItem vHITEM = HItem.getInstance();
    private static final String[] itemFields = new String[]{"name", "url", "photo"};

    @Override
    public ExtractorDescription getDescription() {
        return HItemExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "h-item";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        if (null == node) {
            return false;
        }
        HTMLDocument document = new HTMLDocument(node);
        BNode item = this.getBlankNodeFor(node);
        out.writeTriple((Resource)item, RDF.TYPE, (Value)HItemExtractor.vHITEM.Item);
        String extractorName = this.getDescription().getExtractorName();
        this.addName(document, item);
        this.addPhotos(document, item);
        this.addUrls(document, item);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)this.getCurrentExtractionResult();
        tser.addResourceRoot(document.getPathToLocalRoot(), (Resource)item, this.getClass());
        return true;
    }

    private void mapFieldWithProperty(HTMLDocument fragment, BNode item, String fieldClass, IRI property) {
        HTMLDocument.TextField title = fragment.getSingularTextField(fieldClass);
        this.conditionallyAddStringProperty(title.source(), (Resource)item, property, title.value());
    }

    private void addName(HTMLDocument fragment, BNode item) {
        this.mapFieldWithProperty(fragment, item, "p-" + itemFields[0], HItemExtractor.vHITEM.name);
    }

    private void addPhotos(HTMLDocument fragment, BNode item) throws ExtractionException {
        HTMLDocument.TextField[] photos;
        for (HTMLDocument.TextField photo : photos = fragment.getPluralUrlField("u-" + itemFields[2])) {
            this.addIRIProperty((Resource)item, HItemExtractor.vHITEM.photo, fragment.resolveIRI(photo.value()));
        }
    }

    private void addUrls(HTMLDocument fragment, BNode item) throws ExtractionException {
        HTMLDocument.TextField[] links;
        for (HTMLDocument.TextField link : links = fragment.getPluralUrlField("u-" + itemFields[1])) {
            this.conditionallyAddResourceProperty((Resource)item, HItemExtractor.vHITEM.url, this.getHTMLDocument().resolveIRI(link.value()));
        }
    }
}

