/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.io.IOException;
import java.io.InputStream;
import org.apache.any23.configuration.DefaultConfiguration;
import org.apache.any23.extractor.html.JsoupUtils;
import org.apache.any23.extractor.html.TagSoupParser;
import org.apache.html.dom.HTMLDocumentImpl;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

abstract class TagSoupParsingConfiguration {
    static final String LEGACY_PROPERTY = "any23.tagsoup.legacy";

    TagSoupParsingConfiguration() {
    }

    String name() {
        return this.getClass().getSimpleName();
    }

    abstract org.w3c.dom.Document parse(InputStream var1, String var2, String var3) throws IOException;

    static TagSoupParsingConfiguration getDefault() {
        return Default.instance;
    }

    private static class JsoupConfig
    extends TagSoupParsingConfiguration {
        private static final JsoupConfig instance = new JsoupConfig();

        private JsoupConfig() {
        }

        @Override
        org.w3c.dom.Document parse(InputStream input, String documentIRI, String encoding) throws IOException {
            Document document = JsoupUtils.parse(input, documentIRI, encoding);
            return JsoupConfig.convert(document);
        }

        private static org.w3c.dom.Document convert(Document document) {
            HTMLDocumentImpl w3cDoc = new HTMLDocumentImpl();
            org.jsoup.nodes.Element rootEl = document.children().first();
            if (rootEl != null) {
                NodeTraversor.traverse((NodeVisitor)new DocumentConverter((org.w3c.dom.Document)w3cDoc), (Node)rootEl);
            }
            return w3cDoc;
        }

        private static String stripCDATA(String string) {
            return JsoupConfig.reduceToContent(string, "<![CDATA[", "]]>");
        }

        private static String reduceToContent(String string, String startMarker, String endMarker) {
            char c;
            int i;
            int startContent = -1;
            int l1 = startMarker.length();
            int l2 = endMarker.length();
            for (i = 0; i < string.length() - l1 - l2; ++i) {
                c = string.charAt(i);
                if (Character.isWhitespace(c)) continue;
                if (c == startMarker.charAt(0) && startMarker.equals(string.substring(i, l1 + i))) {
                    startContent = i + l1;
                    break;
                }
                return string;
            }
            if (startContent != -1) {
                for (i = string.length() - 1; i > startContent + l2; --i) {
                    c = string.charAt(i);
                    if (Character.isWhitespace(c)) continue;
                    if (c == endMarker.charAt(l2 - 1) && endMarker.equals(string.substring(i - l2 + 1, i + 1))) {
                        return string.substring(startContent, i - 2);
                    }
                    return string;
                }
            }
            return string;
        }

        static /* synthetic */ JsoupConfig access$100() {
            return instance;
        }

        private static class DocumentConverter
        implements NodeVisitor {
            private final org.w3c.dom.Document doc;
            private Element dest;

            DocumentConverter(org.w3c.dom.Document doc) {
                this.doc = doc;
            }

            public void head(Node source, int depth) {
                if (source instanceof org.jsoup.nodes.Element) {
                    org.jsoup.nodes.Element sourceEl = (org.jsoup.nodes.Element)source;
                    Element el = this.doc.createElement(sourceEl.tagName());
                    this.copyAttributes((Node)sourceEl, el);
                    if (this.dest == null) {
                        this.doc.appendChild(el);
                    } else {
                        this.dest.appendChild(el);
                    }
                    this.dest = el;
                } else if (source instanceof TextNode) {
                    TextNode sourceText = (TextNode)source;
                    Text text = this.doc.createTextNode(sourceText.getWholeText());
                    this.dest.appendChild(text);
                } else if (source instanceof org.jsoup.nodes.Comment) {
                    org.jsoup.nodes.Comment sourceComment = (org.jsoup.nodes.Comment)source;
                    Comment comment = this.doc.createComment(sourceComment.getData());
                    this.dest.appendChild(comment);
                } else if (source instanceof DataNode) {
                    DataNode sourceData = (DataNode)source;
                    Text node = this.doc.createTextNode(JsoupConfig.stripCDATA(sourceData.getWholeData()));
                    this.dest.appendChild(node);
                }
            }

            public void tail(Node source, int depth) {
                if (source instanceof org.jsoup.nodes.Element && this.dest.getParentNode() instanceof Element) {
                    this.dest = (Element)this.dest.getParentNode();
                }
            }

            private void copyAttributes(Node source, Element el) {
                for (Attribute attribute : source.attributes()) {
                    String key = attribute.getKey().replaceAll("[^-a-zA-Z0-9_:.]", "");
                    if (!key.matches("[a-zA-Z_:][-a-zA-Z0-9_:.]*")) continue;
                    el.setAttribute(key, attribute.getValue());
                }
            }
        }
    }

    private static class Default {
        private static final TagSoupParsingConfiguration instance = DefaultConfiguration.singleton().getFlagProperty("any23.tagsoup.legacy") ? TagSoupParser.legacyConfig() : JsoupConfig.access$100();

        private Default() {
        }
    }
}

