/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.SpeciesExtractorFactory;
import org.apache.any23.vocab.WO;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class SpeciesExtractor
extends EntityBasedMicroformatExtractor {
    private static final WO vWO = WO.getInstance();
    private static final String[] classes = new String[]{"kingdom", "phylum", "order", "family", "genus", "species", "class"};

    @Override
    public ExtractorDescription getDescription() {
        return SpeciesExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "biota";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        BNode biota = this.getBlankNodeFor(node);
        this.conditionallyAddResourceProperty((Resource)biota, RDF.TYPE, SpeciesExtractor.vWO.species);
        HTMLDocument fragment = new HTMLDocument(node);
        this.addNames(fragment, (Resource)biota);
        this.addClasses(fragment, (Resource)biota);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)out;
        tser.addResourceRoot(DomUtils.getXPathListForNode(node), (Resource)biota, this.getClass());
        return true;
    }

    private void addNames(HTMLDocument doc, Resource biota) throws ExtractionException {
        HTMLDocument.TextField binomial = doc.getSingularTextField("binomial");
        this.conditionallyAddStringProperty(binomial.source(), biota, SpeciesExtractor.vWO.scientificName, binomial.value());
        HTMLDocument.TextField vernacular = doc.getSingularTextField("vernacular");
        this.conditionallyAddStringProperty(vernacular.source(), biota, SpeciesExtractor.vWO.speciesName, vernacular.value());
    }

    private void addClassesName(HTMLDocument doc, Resource biota) throws ExtractionException {
        for (String clazz : classes) {
            HTMLDocument.TextField classTextField = doc.getSingularTextField(clazz);
            this.conditionallyAddStringProperty(classTextField.source(), biota, this.resolvePropertyName(clazz), classTextField.value());
        }
    }

    private void addClasses(HTMLDocument doc, Resource biota) throws ExtractionException {
        for (String clazz : classes) {
            HTMLDocument.TextField classTextField = doc.getSingularUrlField(clazz);
            if (classTextField.source() == null) continue;
            BNode classBNode = this.getBlankNodeFor(classTextField.source());
            this.addBNodeProperty(biota, vWO.getProperty(clazz), classBNode);
            this.conditionallyAddResourceProperty((Resource)classBNode, RDF.TYPE, this.resolveClassName(clazz));
            HTMLDocument fragment = new HTMLDocument(classTextField.source());
            this.addClassesName(fragment, (Resource)classBNode);
        }
    }

    private IRI resolvePropertyName(String clazz) {
        return vWO.getProperty(String.format("%sName", clazz));
    }

    private IRI resolveClassName(String clazz) {
        String upperCaseClass = clazz.substring(0, 1);
        return vWO.getClass(String.format("%s%s", upperCaseClass.toUpperCase(), clazz.substring(1)));
    }
}

