/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.io.IOException;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.annotations.Includes;
import org.apache.any23.rdf.Any23ValueFactoryWrapper;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class MicroformatExtractor
implements Extractor.TagSoupDOMExtractor {
    public static final String BEGIN_SCRIPT = "<script>";
    public static final String END_SCRIPT = "</script>";
    private HTMLDocument htmlDocument;
    private ExtractionContext context;
    private IRI documentIRI;
    private ExtractionResult out;
    protected final Any23ValueFactoryWrapper valueFactory = new Any23ValueFactoryWrapper((ValueFactory)SimpleValueFactory.getInstance());

    public abstract ExtractorDescription getDescription();

    protected abstract boolean extract() throws ExtractionException;

    public HTMLDocument getHTMLDocument() {
        return this.htmlDocument;
    }

    public ExtractionContext getExtractionContext() {
        return this.context;
    }

    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, Document in, ExtractionResult out) throws IOException, ExtractionException {
        this.htmlDocument = new HTMLDocument(in);
        this.context = extractionContext;
        this.documentIRI = extractionContext.getDocumentIRI();
        this.out = out;
        this.valueFactory.setIssueReport((IssueReport)out);
        try {
            this.extract();
        }
        finally {
            this.valueFactory.setIssueReport(null);
        }
    }

    protected ExtractionResult getCurrentExtractionResult() {
        return this.out;
    }

    protected void setCurrentExtractionResult(ExtractionResult out) {
        this.out = out;
    }

    protected ExtractionResult openSubResult(ExtractionContext context) {
        return this.out.openSubResult(context);
    }

    protected boolean conditionallyAddStringProperty(Node n, Resource subject, IRI p, String value) {
        if (value == null) {
            return false;
        }
        return (value = value.trim()).length() > 0 && this.conditionallyAddLiteralProperty(n, subject, p, this.valueFactory.createLiteral(value));
    }

    protected boolean conditionallyAddLiteralProperty(Node n, Resource subject, IRI property, Literal literal) {
        String literalStr = literal.stringValue();
        if (this.containsScriptBlock(literalStr)) {
            this.out.notifyIssue(IssueReport.IssueLevel.WARNING, String.format("Detected script in literal: [%s]", literalStr), -1L, -1L);
            return false;
        }
        this.out.writeTriple(subject, property, (Value)literal);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)this.out;
        tser.addPropertyPath(this.getClass(), subject, (Resource)property, null, DomUtils.getXPathListForNode(n));
        return true;
    }

    protected boolean conditionallyAddResourceProperty(Resource subject, IRI property, IRI uri) {
        if (uri == null) {
            return false;
        }
        this.out.writeTriple(subject, property, (Value)uri);
        return true;
    }

    protected void addBNodeProperty(Node n, Resource subject, IRI property, BNode bnode) {
        this.out.writeTriple(subject, property, (Value)bnode);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)this.out;
        tser.addPropertyPath(this.getClass(), subject, (Resource)property, bnode, DomUtils.getXPathListForNode(n));
    }

    protected void addBNodeProperty(Resource subject, IRI property, BNode bnode) {
        this.out.writeTriple(subject, property, (Value)bnode);
    }

    protected void addIRIProperty(Resource subject, IRI property, IRI object) {
        this.out.writeTriple(subject, property, (Value)object);
    }

    protected IRI fixLink(String link) {
        return this.valueFactory.fixLink(link, null);
    }

    protected IRI fixLink(String link, String defaultSchema) {
        return this.valueFactory.fixLink(link, defaultSchema);
    }

    private boolean containsScriptBlock(String in) {
        String inLowerCase = in.toLowerCase();
        int beginBlock = inLowerCase.indexOf(BEGIN_SCRIPT);
        if (beginBlock == -1) {
            return false;
        }
        return inLowerCase.indexOf(END_SCRIPT, beginBlock + BEGIN_SCRIPT.length()) != -1;
    }

    public static boolean includes(Class<? extends MicroformatExtractor> including, Class<? extends MicroformatExtractor> included) {
        Class<? extends MicroformatExtractor>[] extractors;
        Includes includes = including.getAnnotation(Includes.class);
        if (includes != null && (extractors = includes.extractors()) != null && extractors.length > 0) {
            for (Class<? extends MicroformatExtractor> extractor : extractors) {
                if (!extractor.equals(included)) continue;
                return true;
            }
        }
        return false;
    }
}

