/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.io.IOException;
import java.util.List;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.HeadLinkExtractorFactory;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HeadLinkExtractor
implements Extractor.TagSoupDOMExtractor {
    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, Document in, ExtractionResult out) throws IOException, ExtractionException {
        HTMLDocument html = new HTMLDocument(in);
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        List<Node> headLinkNodes = DomUtils.findAll(in, "/HTML/HEAD/LINK[(@type='application/rdf+xml' or @type='text/rdf' or @type='application/x-turtle' or @type='application/turtle' or @type='text/turtle' or @type='text/rdf+n3') and @href and @rel]");
        for (Node node : headLinkNodes) {
            String type;
            IRI href = html.resolveIRI(DomUtils.find(node, "@href"));
            String rel = DomUtils.find(node, "@rel");
            out.writeTriple((Resource)extractionContext.getDocumentIRI(), vf.createIRI("http://www.w3.org/1999/xhtml/vocab#" + rel), (Value)href);
            String title = DomUtils.find(node, "@title");
            if (title != null && !"".equals(title)) {
                out.writeTriple((Resource)href, this.getDescription().getPrefixes().expand("dcterms:title"), (Value)vf.createLiteral(title));
            }
            if ((type = DomUtils.find(node, "@type")) == null || "".equals(type)) continue;
            out.writeTriple((Resource)href, this.getDescription().getPrefixes().expand("dcterms:format"), (Value)vf.createLiteral(type));
        }
    }

    public ExtractorDescription getDescription() {
        return HeadLinkExtractorFactory.getDescriptionInstance();
    }
}

