/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HListingExtractorFactory;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.vocab.FOAF;
import org.apache.any23.vocab.HListing;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HListingExtractor
extends EntityBasedMicroformatExtractor {
    private static final HListing hLISTING = HListing.getInstance();
    private static final FOAF foaf = FOAF.getInstance();
    private static final Set<String> ActionClasses = new HashSet<String>(){
        {
            this.add("sell");
            this.add("rent");
            this.add("trade");
            this.add("meet");
            this.add("announce");
            this.add("offer");
            this.add("wanted");
            this.add("event");
            this.add("service");
        }
    };
    private static final List<String> validClassesForAddress = Arrays.asList("post-office-box", "extended-address", "street-address", "locality", "region", "postal-code", "country-name");
    private HTMLDocument fragment;

    @Override
    public ExtractorDescription getDescription() {
        return HListingExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "hlisting";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        this.fragment = new HTMLDocument(node);
        BNode listing = this.getBlankNodeFor(node);
        out.writeTriple((Resource)listing, RDF.TYPE, (Value)HListingExtractor.hLISTING.Listing);
        for (String action : this.findActions(this.fragment)) {
            out.writeTriple((Resource)listing, HListingExtractor.hLISTING.action, (Value)hLISTING.getClass(action));
        }
        out.writeTriple((Resource)listing, HListingExtractor.hLISTING.lister, (Value)this.addLister());
        this.addItem((Resource)listing);
        this.addDateTimes((Resource)listing);
        this.addPrice((Resource)listing);
        this.addDescription((Resource)listing);
        this.addSummary((Resource)listing);
        this.addPermalink((Resource)listing);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)out;
        tser.addResourceRoot(DomUtils.getXPathListForNode(node), (Resource)listing, this.getClass());
        return true;
    }

    private void addItem(Resource listing) throws ExtractionException {
        Node node = this.fragment.findMicroformattedObjectNode("*", "item");
        if (null == node) {
            return;
        }
        BNode blankItem = this.valueFactory.createBNode();
        this.addBNodeProperty(node, listing, HListingExtractor.hLISTING.item, blankItem);
        this.addIRIProperty((Resource)blankItem, RDF.TYPE, HListingExtractor.hLISTING.Item);
        HTMLDocument item = new HTMLDocument(node);
        this.addItemName(item, (Resource)blankItem);
        this.addItemUrl(item, (Resource)blankItem);
        this.addItemPhoto(this.fragment, (Resource)blankItem);
        this.addItemAddresses(this.fragment, (Resource)blankItem);
    }

    private void addItemAddresses(HTMLDocument doc, Resource blankItem) {
        String extractorName = this.getDescription().getExtractorName();
        for (Node node : doc.findAll(".//*[contains(@class,'adr')]//*[@class]")) {
            String[] klasses;
            for (String klass : klasses = node.getAttributes().getNamedItem("class").getNodeValue().split("\\s+")) {
                String value;
                if (!validClassesForAddress.contains(klass) || null == (value = node.getNodeValue()) || "".equals(value)) continue;
                IRI property = hLISTING.getPropertyCamelCase(klass);
                this.conditionallyAddLiteralProperty(node, blankItem, property, this.valueFactory.createLiteral(value));
            }
        }
    }

    private void addPermalink(Resource listing) {
        String link = this.fragment.find(".//A[contains(@rel,'self') and contains(@rel,'bookmark')]/@href");
        this.conditionallyAddStringProperty(this.fragment.getDocument(), listing, HListingExtractor.hLISTING.permalink, link);
    }

    private void addPrice(Resource listing) {
        HTMLDocument.TextField price = this.fragment.getSingularTextField("price");
        this.conditionallyAddStringProperty(price.source(), listing, HListingExtractor.hLISTING.price, price.value());
    }

    private void addDescription(Resource listing) {
        HTMLDocument.TextField description = this.fragment.getSingularTextField("description");
        this.conditionallyAddStringProperty(description.source(), listing, HListingExtractor.hLISTING.description, description.value());
    }

    private void addSummary(Resource listing) {
        HTMLDocument.TextField summary = this.fragment.getSingularTextField("summary");
        this.conditionallyAddStringProperty(summary.source(), listing, HListingExtractor.hLISTING.summary, summary.value());
    }

    private void addDateTimes(Resource listing) {
        HTMLDocument.TextField listed = this.fragment.getSingularTextField("dtlisted");
        this.conditionallyAddStringProperty(listed.source(), listing, HListingExtractor.hLISTING.dtlisted, listed.value());
        HTMLDocument.TextField expired = this.fragment.getSingularTextField("dtexpired");
        this.conditionallyAddStringProperty(expired.source(), listing, HListingExtractor.hLISTING.dtexpired, expired.value());
    }

    private Resource addLister() throws ExtractionException {
        BNode blankLister = this.valueFactory.createBNode();
        this.addIRIProperty((Resource)blankLister, RDF.TYPE, HListingExtractor.hLISTING.Lister);
        Node node = this.fragment.findMicroformattedObjectNode("*", "lister");
        if (null == node) {
            return blankLister;
        }
        HTMLDocument listerNode = new HTMLDocument(node);
        this.addListerFn(listerNode, (Resource)blankLister);
        this.addListerOrg(listerNode, (Resource)blankLister);
        this.addListerEmail(listerNode, (Resource)blankLister);
        this.addListerUrl(listerNode, (Resource)blankLister);
        this.addListerTel(listerNode, (Resource)blankLister);
        this.addListerLogo(listerNode, (Resource)blankLister);
        return blankLister;
    }

    private void addListerTel(HTMLDocument doc, Resource blankLister) {
        HTMLDocument.TextField tel = doc.getSingularTextField("tel");
        this.conditionallyAddStringProperty(tel.source(), blankLister, HListingExtractor.hLISTING.tel, tel.value());
    }

    private void addListerUrl(HTMLDocument doc, Resource blankLister) throws ExtractionException {
        HTMLDocument.TextField url = doc.getSingularUrlField("url");
        this.conditionallyAddResourceProperty(blankLister, HListingExtractor.hLISTING.listerUrl, this.getHTMLDocument().resolveIRI(url.value()));
    }

    private void addListerEmail(HTMLDocument doc, Resource blankLister) {
        HTMLDocument.TextField email = doc.getSingularUrlField("email");
        this.conditionallyAddResourceProperty(blankLister, HListingExtractor.foaf.mbox, this.fixLink(email.value(), "mailto"));
    }

    private void addListerFn(HTMLDocument doc, Resource blankLister) {
        HTMLDocument.TextField fn = doc.getSingularTextField("fn");
        this.conditionallyAddStringProperty(fn.source(), blankLister, HListingExtractor.hLISTING.listerName, fn.value());
    }

    private void addListerLogo(HTMLDocument doc, Resource blankLister) throws ExtractionException {
        HTMLDocument.TextField logo = doc.getSingularUrlField("logo");
        this.conditionallyAddResourceProperty(blankLister, HListingExtractor.hLISTING.listerLogo, this.getHTMLDocument().resolveIRI(logo.value()));
    }

    private void addListerOrg(HTMLDocument doc, Resource blankLister) {
        HTMLDocument.TextField org = doc.getSingularTextField("org");
        this.conditionallyAddStringProperty(org.source(), blankLister, HListingExtractor.hLISTING.listerOrg, org.value());
    }

    private void addItemName(HTMLDocument item, Resource blankItem) {
        HTMLDocument.TextField fn = item.getSingularTextField("fn");
        this.conditionallyAddStringProperty(fn.source(), blankItem, HListingExtractor.hLISTING.itemName, fn.value());
    }

    private void addItemUrl(HTMLDocument item, Resource blankItem) throws ExtractionException {
        HTMLDocument.TextField url = item.getSingularUrlField("url");
        this.conditionallyAddResourceProperty(blankItem, HListingExtractor.hLISTING.itemUrl, this.getHTMLDocument().resolveIRI(url.value()));
    }

    private void addItemPhoto(HTMLDocument doc, Resource blankLister) throws ExtractionException {
        String url = doc.findMicroformattedValue("*", "item", "A", "photo", "@href");
        this.conditionallyAddResourceProperty(blankLister, HListingExtractor.hLISTING.itemPhoto, this.getHTMLDocument().resolveIRI(url));
        url = doc.findMicroformattedValue("*", "item", "IMG", "photo", "@src");
        this.conditionallyAddResourceProperty(blankLister, HListingExtractor.hLISTING.itemPhoto, this.getHTMLDocument().resolveIRI(url));
        url = doc.findMicroformattedValue("*", "photo", "IMG", "", "@src");
        this.conditionallyAddResourceProperty(blankLister, HListingExtractor.hLISTING.itemPhoto, this.getHTMLDocument().resolveIRI(url));
    }

    private List<String> findActions(HTMLDocument doc) {
        ArrayList<String> actions = new ArrayList<String>(0);
        String[] classes = doc.readAttribute("class").split("\\s+");
        for (String klass : classes) {
            if (!ActionClasses.contains(klass)) continue;
            actions.add(klass);
        }
        for (Node action : doc.findAll("./*[@class]/@class")) {
            for (String substring : action.getNodeValue().split("\\s+")) {
                if (!ActionClasses.contains(substring)) continue;
                actions.add(substring);
            }
        }
        return actions;
    }
}

