/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.util.List;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.MicroformatExtractor;
import org.apache.any23.rdf.RDFUtils;
import org.eclipse.rdf4j.model.BNode;
import org.w3c.dom.Node;

public abstract class EntityBasedMicroformatExtractor
extends MicroformatExtractor {
    protected abstract String getBaseClassName();

    protected abstract void resetExtractor();

    protected abstract boolean extractEntity(Node var1, ExtractionResult var2) throws ExtractionException;

    @Override
    public boolean extract() throws ExtractionException {
        List<Node> nodes = DomUtils.findAllByClassName(this.getHTMLDocument().getDocument(), this.getBaseClassName());
        boolean foundAny = false;
        int count = 1;
        for (Node node : nodes) {
            this.resetExtractor();
            String contextID = Integer.toString(count);
            ExtractionResult subResult = this.openSubResult(this.getExtractionContext().copy(contextID));
            foundAny |= this.extractEntity(node, subResult);
            subResult.close();
            ++count;
        }
        return foundAny;
    }

    protected BNode getBlankNodeFor(Node node) {
        return RDFUtils.getBNode(this.getDocumentIRI() + "#" + DomUtils.getXPathForNode(node));
    }
}

