/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail.helpers;

import java.io.IOException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.trig.TriGParser;

public class SPARQLUpdateDataBlockParser
extends TriGParser {
    private boolean allowBlankNodes = true;
    private int lineNumberOffset;

    public SPARQLUpdateDataBlockParser() {
    }

    public SPARQLUpdateDataBlockParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public RDFFormat getRDFFormat() {
        return null;
    }

    protected void parseGraph() throws RDFParseException, RDFHandlerException, IOException {
        super.parseGraph();
        this.skipOptionalPeriod();
    }

    protected Resource parseImplicitBlank() throws IOException, RDFParseException, RDFHandlerException {
        if (this.isAllowBlankNodes()) {
            return super.parseImplicitBlank();
        }
        throw new RDFParseException("blank nodes not allowed in data block");
    }

    protected BNode parseNodeID() throws IOException, RDFParseException {
        if (this.isAllowBlankNodes()) {
            return super.parseNodeID();
        }
        throw new RDFParseException("blank nodes not allowed in data block");
    }

    public boolean isAllowBlankNodes() {
        return this.allowBlankNodes;
    }

    public void setAllowBlankNodes(boolean allowBlankNodes) {
        this.allowBlankNodes = allowBlankNodes;
    }

    protected int getLineNumber() {
        return super.getLineNumber() - this.lineNumberOffset;
    }

    private void skipOptionalPeriod() throws RDFHandlerException, IOException {
        this.skipWSC();
        int c = this.peekCodePoint();
        if (c == 46) {
            this.readCodePoint();
        }
    }

    public void setLineNumberOffset(int lineNumberOffset) {
        this.lineNumberOffset = lineNumberOffset;
    }
}

