/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import java.util.ArrayList;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.repository.sail.SailQuery;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;

public class SailTupleQuery
extends SailQuery
implements TupleQuery {
    protected SailTupleQuery(ParsedTupleQuery tupleQuery, SailRepositoryConnection sailConnection) {
        super((ParsedQuery)tupleQuery, sailConnection);
    }

    public ParsedTupleQuery getParsedQuery() {
        return (ParsedTupleQuery)super.getParsedQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleQueryResult evaluate() throws QueryEvaluationException {
        TupleExpr tupleExpr = this.getParsedQuery().getTupleExpr();
        CloseableIteration bindingsIter1 = null;
        CloseableIteration bindingsIter2 = null;
        IteratingTupleQueryResult result = null;
        boolean allGood = false;
        try {
            SailConnection sailCon = this.getConnection().getSailConnection();
            bindingsIter1 = sailCon.evaluate(tupleExpr, this.getActiveDataset(), this.getBindings(), this.getIncludeInferred());
            bindingsIter2 = this.enforceMaxQueryTime(bindingsIter1);
            result = new IteratingTupleQueryResult(new ArrayList(tupleExpr.getBindingNames()), bindingsIter2);
            allGood = true;
            IteratingTupleQueryResult iteratingTupleQueryResult = result;
            return iteratingTupleQueryResult;
        }
        catch (SailException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (!allGood) {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    try {
                        if (bindingsIter2 != null) {
                            bindingsIter2.close();
                        }
                    }
                    finally {
                        if (bindingsIter1 != null) {
                            bindingsIter1.close();
                        }
                    }
                }
            }
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        TupleQueryResult queryResult = this.evaluate();
        QueryResults.report((TupleQueryResult)queryResult, (QueryResultHandler)handler);
    }
}

