/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleHandlerException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class BenchmarkTripleHandler
implements TripleHandler {
    private TripleHandler underlyingHandler;
    private final Map<String, StatObject> stats;

    public BenchmarkTripleHandler(TripleHandler tripleHandler) {
        if (tripleHandler == null) {
            throw new NullPointerException("tripleHandler cannot be null.");
        }
        this.underlyingHandler = tripleHandler;
        this.stats = new HashMap<String, StatObject>();
        this.stats.put("SUM", new StatObject());
    }

    public String report() {
        StringBuilder sb = new StringBuilder();
        StatObject sum = this.stats.get("SUM");
        sb.append("\n>Summary: ");
        sb.append("\n   -total calls: ").append(sum.methodCalls);
        sb.append("\n   -total triples: ").append(sum.triples);
        sb.append("\n   -total runtime: ").append(sum.runtime).append(" ms!");
        if (sum.runtime != 0L) {
            sb.append("\n   -tripls/ms: ").append((long)sum.triples.get() / sum.runtime);
        }
        if (sum.methodCalls.get() != 0) {
            sb.append("\n   -ms/calls: ").append(sum.runtime / (long)sum.methodCalls.get());
        }
        this.stats.remove("SUM");
        for (Map.Entry<String, StatObject> ent : this.stats.entrySet()) {
            sb.append("\n>Extractor: ").append(ent.getKey());
            sb.append("\n   -total calls: ").append(ent.getValue().methodCalls);
            sb.append("\n   -total triples: ").append(ent.getValue().triples);
            sb.append("\n   -total runtime: ").append(ent.getValue().runtime).append(" ms!");
            if (ent.getValue().runtime != 0L) {
                sb.append("\n   -tripls/ms: ").append((long)ent.getValue().triples.get() / ent.getValue().runtime);
            }
            if (ent.getValue().methodCalls.get() == 0) continue;
            sb.append("\n   -ms/calls: ").append(ent.getValue().runtime / (long)ent.getValue().methodCalls.get());
        }
        return sb.toString();
    }

    public void startDocument(IRI documentIRI) throws TripleHandlerException {
        this.underlyingHandler.startDocument(documentIRI);
    }

    public void close() throws TripleHandlerException {
        this.underlyingHandler.close();
    }

    public void closeContext(ExtractionContext context) throws TripleHandlerException {
        if (this.stats.containsKey(context.getExtractorName())) {
            this.stats.get(context.getExtractorName()).interimStop();
            this.stats.get("SUM").interimStop();
        }
        this.underlyingHandler.closeContext(context);
    }

    public void openContext(ExtractionContext context) throws TripleHandlerException {
        if (!this.stats.containsKey(context.getExtractorName())) {
            this.stats.put(context.getExtractorName(), new StatObject());
        }
        this.stats.get((Object)context.getExtractorName()).methodCalls.incrementAndGet();
        this.stats.get(context.getExtractorName()).interimStart();
        this.stats.get((Object)"SUM").methodCalls.incrementAndGet();
        this.stats.get("SUM").interimStart();
        this.underlyingHandler.openContext(context);
    }

    public void receiveTriple(Resource s, IRI p, Value o, IRI g, ExtractionContext context) throws TripleHandlerException {
        if (!this.stats.containsKey(context.getExtractorName())) {
            this.stats.put(context.getExtractorName(), new StatObject());
        }
        this.stats.get((Object)context.getExtractorName()).triples.incrementAndGet();
        this.stats.get((Object)"SUM").triples.incrementAndGet();
        this.underlyingHandler.receiveTriple(s, p, o, g, context);
    }

    public void receiveNamespace(String prefix, String uri, ExtractionContext context) throws TripleHandlerException {
        this.underlyingHandler.receiveNamespace(prefix, uri, context);
    }

    public void endDocument(IRI documentIRI) throws TripleHandlerException {
        this.underlyingHandler.endDocument(documentIRI);
    }

    public void setContentLength(long contentLength) {
        this.underlyingHandler.setContentLength(contentLength);
    }

    private class StatObject {
        AtomicInteger methodCalls = new AtomicInteger(0);
        AtomicInteger triples = new AtomicInteger(0);
        long runtime = 0L;
        long intStart = 0L;

        private StatObject() {
        }

        public void interimStart() {
            this.intStart = System.currentTimeMillis();
        }

        public void interimStop() {
            this.runtime += System.currentTimeMillis() - this.intStart;
            this.intStart = 0L;
        }
    }
}

