/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.validator.rule;

import java.util.List;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.validator.DOMDocument;
import org.apache.any23.validator.Fix;
import org.apache.any23.validator.Rule;
import org.apache.any23.validator.RuleContext;
import org.w3c.dom.Node;

public class MissingItemscopeAttributeValueFix
implements Fix {
    private static final String EMPTY_ITEMSCOPE_VALUE = "itemscope";
    private static final String ITEMSCOPE = "itemscope";

    @Override
    public String getHRName() {
        return "missing-itemscope-value-fix";
    }

    @Override
    public void execute(Rule rule, RuleContext context, DOMDocument document) {
        List<Node> itemScopeContainerElements = document.getNodesWithAttribute("itemscope");
        for (Node itemScopeContainerElement : itemScopeContainerElements) {
            Node newItemScopeContainerElement = itemScopeContainerElement;
            Node itemScopeNode = newItemScopeContainerElement.getAttributes().getNamedItem("itemscope");
            if (itemScopeNode.getTextContent() != null && itemScopeNode.getTextContent() != "") continue;
            String node = DomUtils.getXPathForNode(itemScopeContainerElement);
            document.addAttribute(node, "itemscope", "itemscope");
        }
    }
}

