/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.validator;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.any23.validator.SerializationException;
import org.apache.any23.validator.ValidationReport;
import org.apache.any23.validator.ValidationReportSerializer;
import org.w3c.dom.Element;

public class XMLValidationReportSerializer
implements ValidationReportSerializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ValidationReport vr, OutputStream os) throws SerializationException {
        PrintStream ps = new PrintStream(os);
        try {
            this.serializeObject(vr, ps);
        }
        finally {
            ps.flush();
        }
    }

    private void serializeObject(Object o, PrintStream ps) throws SerializationException {
        if (o == null) {
            return;
        }
        Class<?> oClass = o.getClass();
        String oClassName = this.getClassName(oClass);
        ps.printf("<%s>%n", oClassName);
        List<Method> getters = this.filterGetters(o.getClass());
        if (getters.isEmpty()) {
            ps.print(o.toString());
            return;
        }
        for (Method getter : getters) {
            this.serializeGetterValue(o, getter, ps);
        }
        ps.printf("</%s>%n", oClassName);
    }

    private String getClassName(Class<? extends Object> oClass) {
        NodeName nodeName = oClass.getAnnotation(NodeName.class);
        if (nodeName != null) {
            return nodeName.value();
        }
        String simpleName = oClass.getSimpleName();
        return Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
    }

    private List<Method> filterGetters(Class<? extends Object> c) {
        Method[] methods = c.getDeclaredMethods();
        ArrayList<Method> filtered = new ArrayList<Method>();
        for (Method method : methods) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            String methodName = method.getName();
            if (method.getParameterTypes().length != 0 || (methodName.length() <= 3 || methodName.indexOf("get") != 0) && (methodName.length() <= 2 || methodName.indexOf("is") != 0)) continue;
            filtered.add(method);
        }
        return filtered;
    }

    public void serializeGetterValue(Object o, Method m, PrintStream ps) throws SerializationException {
        Object value;
        String methodName = m.getName();
        try {
            value = m.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            throw new SerializationException(String.format("Error while reading method '%s'", methodName), e);
        }
        String property = this.getPropertyFromMethodName(methodName);
        if (this.isManaged(value)) {
            ps.printf("<%s>%n", property);
            this.printObject(value, ps);
            ps.printf("</%s>%n", property);
        } else {
            List<Method> getters = this.filterGetters(value.getClass());
            for (Method getter : getters) {
                this.serializeGetterValue(value, getter, ps);
            }
        }
    }

    private String getPropertyFromMethodName(String methodName) {
        int i = methodName.indexOf("is");
        if (i == 0) {
            return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
        }
        return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
    }

    private void printObject(Object o, PrintStream ps) throws SerializationException {
        if (o == null) {
            return;
        }
        if (o instanceof Element) {
            ps.print(o.toString());
            return;
        }
        if (o instanceof Array) {
            Object[] array = (Object[])o;
            if (array.length == 0) {
                return;
            }
            for (Object a : array) {
                this.serializeObject(a, ps);
            }
            return;
        }
        if (o instanceof Collection) {
            Collection collection = (Collection)o;
            if (collection.isEmpty()) {
                return;
            }
            for (Object e : collection) {
                this.serializeObject(e, ps);
            }
            return;
        }
        ps.print(o.toString());
    }

    private boolean isManaged(Object o) {
        return o == null || o instanceof String || o.getClass().isPrimitive() || o instanceof Collection || o instanceof Element;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface NodeName {
        public String value();
    }
}

