/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.validator;

import java.io.Serializable;
import java.util.List;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.validator.Fix;
import org.apache.any23.validator.Rule;
import org.w3c.dom.Node;

public interface ValidationReport
extends Serializable {
    public List<Issue> getIssues();

    public List<RuleActivation> getRuleActivations();

    public List<Error> getErrors();

    public static class FixError
    extends Error {
        private static final long serialVersionUID = 1L;
        private final Fix origin;

        public FixError(Fix f, Exception e, String msg) {
            super(e, msg);
            this.origin = f;
        }

        public Fix getOrigin() {
            return this.origin;
        }

        @Override
        public String toString() {
            return String.format("%s - %s", super.toString(), this.origin.getHRName());
        }
    }

    public static class RuleError
    extends Error {
        private static final long serialVersionUID = 1L;
        private final Rule origin;

        public RuleError(Rule r, Exception e, String msg) {
            super(e, msg);
            if (r == null) {
                throw new NullPointerException("rule cannot be null.");
            }
            this.origin = r;
        }

        public Rule getOrigin() {
            return this.origin;
        }

        @Override
        public String toString() {
            return String.format("%s - %s", super.toString(), this.origin.getHRName());
        }
    }

    public static abstract class Error
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Exception cause;
        private final String message;

        public Error(Exception e, String msg) {
            if (e == null) {
                throw new NullPointerException("exception cannot be null.");
            }
            if (msg == null) {
                throw new NullPointerException("message cannot be null.");
            }
            this.cause = e;
            this.message = msg;
        }

        public Exception getCause() {
            return this.cause;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return String.format("%s %s %s", this.getClass().getName(), this.cause, this.message);
        }
    }

    public static class RuleActivation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String ruleStr;

        public RuleActivation(Rule r) {
            if (r == null) {
                throw new NullPointerException("rule cannot be null.");
            }
            this.ruleStr = r.getHRName();
        }

        public String getRuleStr() {
            return this.ruleStr;
        }

        public String toString() {
            return this.ruleStr;
        }
    }

    public static class Issue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IssueLevel level;
        private final String message;
        private final transient Node origin;

        public Issue(IssueLevel level, String message, Node origin) {
            if (level == null) {
                throw new NullPointerException("level cannot be null.");
            }
            if (message == null) {
                throw new NullPointerException("message cannot be null.");
            }
            if (origin == null) {
                throw new NullPointerException("origin cannot be null.");
            }
            this.level = level;
            this.message = message;
            this.origin = origin;
        }

        public String getMessage() {
            return this.message;
        }

        public IssueLevel getLevel() {
            return this.level;
        }

        public Node getOrigin() {
            return this.origin;
        }

        public String toString() {
            return String.format("Issue %s '%s' %s", new Object[]{this.level, this.message, DomUtils.getXPathForNode(this.origin)});
        }
    }

    public static enum IssueLevel {
        ERROR,
        WARNING,
        INFO;

    }
}

