/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.rdf;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.rdf.RDFUtils;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Any23ValueFactoryWrapper
implements ValueFactory {
    private static final Logger logger = LoggerFactory.getLogger(Any23ValueFactoryWrapper.class);
    private final ValueFactory wrappedFactory;
    private IssueReport issueReport;
    private String defaultLiteralLanguage;

    public Any23ValueFactoryWrapper(ValueFactory factory, IssueReport er, String defaultLitLanguage) {
        if (factory == null) {
            throw new NullPointerException("factory cannot be null.");
        }
        this.wrappedFactory = factory;
        this.issueReport = er;
        this.defaultLiteralLanguage = defaultLitLanguage;
    }

    public Any23ValueFactoryWrapper(ValueFactory vFactory, IssueReport er) {
        this(vFactory, er, null);
    }

    public Any23ValueFactoryWrapper(ValueFactory vFactory) {
        this(vFactory, null, null);
    }

    public IssueReport getIssueReport() {
        return this.issueReport;
    }

    public void setIssueReport(IssueReport er) {
        this.issueReport = er;
    }

    public String getDefaultLiteralLanguage() {
        return this.defaultLiteralLanguage;
    }

    public BNode createBNode() {
        return this.wrappedFactory.createBNode();
    }

    public BNode createBNode(String id) {
        if (id == null) {
            return null;
        }
        return this.wrappedFactory.createBNode(id);
    }

    public Literal createLiteral(String content) {
        if (content == null) {
            return null;
        }
        if (this.defaultLiteralLanguage == null) {
            return this.wrappedFactory.createLiteral(content);
        }
        return this.wrappedFactory.createLiteral(content, this.defaultLiteralLanguage);
    }

    public Literal createLiteral(boolean b) {
        return this.wrappedFactory.createLiteral(b);
    }

    public Literal createLiteral(byte b) {
        return this.wrappedFactory.createLiteral(b);
    }

    public Literal createLiteral(short i) {
        return this.wrappedFactory.createLiteral(i);
    }

    public Literal createLiteral(int i) {
        return this.wrappedFactory.createLiteral(i);
    }

    public Literal createLiteral(long l) {
        return this.wrappedFactory.createLiteral(l);
    }

    public Literal createLiteral(float v) {
        return this.wrappedFactory.createLiteral(v);
    }

    public Literal createLiteral(double v) {
        return this.wrappedFactory.createLiteral(v);
    }

    public Literal createLiteral(BigDecimal v) {
        return this.wrappedFactory.createLiteral(v);
    }

    public Literal createLiteral(BigInteger v) {
        return this.wrappedFactory.createLiteral(v);
    }

    public Literal createLiteral(XMLGregorianCalendar calendar) {
        return this.wrappedFactory.createLiteral(calendar);
    }

    public Literal createLiteral(String label, String language) {
        if (label == null) {
            return null;
        }
        return this.wrappedFactory.createLiteral(label, language);
    }

    public Literal createLiteral(String pref, IRI value) {
        if (pref == null) {
            return null;
        }
        return this.wrappedFactory.createLiteral(pref, value);
    }

    public Literal createLiteral(Date date) {
        return this.wrappedFactory.createLiteral(date);
    }

    public Statement createStatement(Resource sub, IRI pre, Value obj) {
        if (sub == null || pre == null || obj == null) {
            return null;
        }
        return this.wrappedFactory.createStatement(sub, pre, obj);
    }

    public Statement createStatement(Resource sub, IRI pre, Value obj, Resource context) {
        if (sub == null || pre == null || obj == null) {
            return null;
        }
        return this.wrappedFactory.createStatement(sub, pre, obj, context);
    }

    public IRI createIRI(String uriStr) {
        if (uriStr == null) {
            return null;
        }
        try {
            return this.wrappedFactory.createIRI(RDFUtils.fixIRIWithException(uriStr));
        }
        catch (Exception e) {
            this.reportError(e);
            return null;
        }
    }

    public IRI createIRI(String namespace, String localName) {
        if (namespace == null || localName == null) {
            return null;
        }
        return this.wrappedFactory.createIRI(RDFUtils.fixIRIWithException(namespace), localName);
    }

    public IRI resolveIRI(String uri, URI baseIRI) {
        try {
            return this.wrappedFactory.createIRI(baseIRI.resolve(RDFUtils.fixIRIWithException(uri)).toString());
        }
        catch (IllegalArgumentException iae) {
            this.reportError(iae);
            return null;
        }
    }

    public IRI fixIRI(String iri) {
        try {
            return this.wrappedFactory.createIRI(RDFUtils.fixIRIWithException(iri));
        }
        catch (Exception e) {
            this.reportError(e);
            return null;
        }
    }

    public IRI fixLink(String link, String defaultSchema) {
        if (link == null) {
            return null;
        }
        if ("".equals(link = this.fixWhiteSpace(link))) {
            return null;
        }
        if (defaultSchema != null && !link.startsWith(defaultSchema + ":")) {
            link = defaultSchema + ":" + link;
        }
        return this.fixIRI(link);
    }

    public String fixWhiteSpace(String name) {
        return name.replaceAll("\\s+", " ").trim();
    }

    private void reportError(Exception e) {
        if (this.issueReport == null) {
            logger.warn(e.getMessage());
        } else {
            this.issueReport.notifyIssue(IssueReport.IssueLevel.WARNING, e.getMessage(), -1L, -1L);
        }
    }
}

