/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.any23.http.DefaultHTTPClientConfiguration;
import org.apache.any23.http.HTTPClient;
import org.apache.any23.http.HTTPClientConfiguration;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public class DefaultHTTPClient
implements HTTPClient {
    private static final Pattern ESCAPED_PATTERN = Pattern.compile("%[0-9a-f]{2}", 2);
    private final MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
    private HTTPClientConfiguration configuration;
    private HttpClient client = null;
    private long _contentLength = -1L;
    private String actualDocumentIRI = null;
    private String contentType = null;

    public static final boolean isUrlEncoded(String url) {
        return ESCAPED_PATTERN.matcher(url).find();
    }

    public static DefaultHTTPClient createInitializedHTTPClient() {
        DefaultHTTPClient defaultHTTPClient = new DefaultHTTPClient();
        defaultHTTPClient.init(DefaultHTTPClientConfiguration.singleton());
        return defaultHTTPClient;
    }

    @Override
    public void init(HTTPClientConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("Illegal configuration, cannot be null.");
        }
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream openInputStream(String uri) throws IOException {
        GetMethod method = null;
        try {
            String uriStr;
            this.ensureClientInitialized();
            try {
                URI uriObj = new URI(uri, DefaultHTTPClient.isUrlEncoded(uri));
                uriStr = uriObj.toString();
            }
            catch (URIException e) {
                throw new IllegalArgumentException("Invalid IRI string.", e);
            }
            method = new GetMethod(uriStr);
            method.setFollowRedirects(true);
            this.client.executeMethod((HttpMethod)method);
            this._contentLength = method.getResponseContentLength();
            Header contentTypeHeader = method.getResponseHeader("Content-Type");
            String string = this.contentType = contentTypeHeader == null ? null : contentTypeHeader.getValue();
            if (method.getStatusCode() != 200) {
                throw new IOException("Failed to fetch " + uri + ": " + method.getStatusCode() + " " + method.getStatusText());
            }
            this.actualDocumentIRI = method.getURI().toString();
            byte[] response = method.getResponseBody();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(response);
            return byteArrayInputStream;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public void close() {
        this.manager.shutdown();
    }

    @Override
    public long getContentLength() {
        return this._contentLength;
    }

    @Override
    public String getActualDocumentIRI() {
        return this.actualDocumentIRI;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    protected int getConnectionTimeout() {
        return this.configuration.getDefaultTimeout();
    }

    protected int getSoTimeout() {
        return this.configuration.getDefaultTimeout();
    }

    private void ensureClientInitialized() {
        if (this.configuration == null) {
            throw new IllegalStateException("client must be initialized first.");
        }
        if (this.client != null) {
            return;
        }
        this.client = new HttpClient((HttpConnectionManager)this.manager);
        HttpConnectionManager connectionManager = this.client.getHttpConnectionManager();
        HttpConnectionManagerParams params = connectionManager.getParams();
        params.setConnectionTimeout(this.configuration.getDefaultTimeout());
        params.setSoTimeout(this.configuration.getDefaultTimeout());
        params.setMaxTotalConnections(this.configuration.getMaxConnections());
        HostConfiguration hostConf = this.client.getHostConfiguration();
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(new Header("User-Agent", this.configuration.getUserAgent()));
        if (this.configuration.getAcceptHeader() != null) {
            headers.add(new Header("Accept", this.configuration.getAcceptHeader()));
        }
        headers.add(new Header("Accept-Language", "en-us,en-gb,en,*;q=0.3"));
        headers.add(new Header("Accept-Charset", "utf-8,iso-8859-1;q=0.7,*;q=0.5"));
        hostConf.getParams().setParameter("http.default-headers", headers);
    }
}

