/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.rdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.rdf.RDFHandlerAdapter;
import org.apache.any23.rdf.Any23ValueFactoryWrapper;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.RDFaParserSettings;
import org.eclipse.rdf4j.rio.helpers.RDFaVersion;
import org.eclipse.rdf4j.rio.turtle.TurtleParser;
import org.semanticweb.owlapi.rio.OWLAPIRDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFParserFactory {
    private static final Logger logger = LoggerFactory.getLogger(RDFParserFactory.class);
    private static RDFParserFactory instance;

    public static RDFParserFactory getInstance() {
        if (instance == null) {
            instance = new RDFParserFactory();
        }
        return instance;
    }

    public RDFParser getTurtleParserInstance(boolean verifyDataType, boolean stopAtFirstError, ExtractionContext extractionContext, ExtractionResult extractionResult) {
        if (extractionResult == null) {
            throw new NullPointerException("extractionResult cannot be null.");
        }
        ExtendedTurtleParser parser = new ExtendedTurtleParser();
        this.configureParser((RDFParser)parser, verifyDataType, stopAtFirstError, extractionContext, extractionResult);
        return parser;
    }

    public RDFParser getRDFa10Parser(boolean verifyDataType, boolean stopAtFirstError, ExtractionContext extractionContext, ExtractionResult extractionResult) {
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.RDFA);
        parser.getParserConfig().set(RDFaParserSettings.RDFA_COMPATIBILITY, (Object)RDFaVersion.RDFA_1_0);
        this.configureParser(parser, verifyDataType, stopAtFirstError, extractionContext, extractionResult);
        return parser;
    }

    public RDFParser getRDFa11Parser(boolean verifyDataType, boolean stopAtFirstError, ExtractionContext extractionContext, ExtractionResult extractionResult) {
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.RDFA);
        parser.getParserConfig().set(RDFaParserSettings.RDFA_COMPATIBILITY, (Object)RDFaVersion.RDFA_1_1);
        this.configureParser(parser, verifyDataType, stopAtFirstError, extractionContext, extractionResult);
        return parser;
    }

    public RDFParser getRDFXMLParser(boolean verifyDataType, boolean stopAtFirstError, ExtractionContext extractionContext, ExtractionResult extractionResult) {
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.RDFXML);
        this.configureParser(parser, verifyDataType, stopAtFirstError, extractionContext, extractionResult);
        return parser;
    }

    public RDFParser getNTriplesParser(boolean verifyDataType, boolean stopAtFirstError, ExtractionContext extractionContext, ExtractionResult extractionResult) {
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.NTRIPLES);
        this.configureParser(parser, verifyDataType, stopAtFirstError, extractionContext, extractionResult);
        return parser;
    }

    public RDFParser getNQuadsParser(boolean verifyDataType, boolean stopAtFirstError, ExtractionContext extractionContext, ExtractionResult extractionResult) {
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.NQUADS);
        this.configureParser(parser, verifyDataType, stopAtFirstError, extractionContext, extractionResult);
        return parser;
    }

    public RDFParser getManchesterSyntaxParser(boolean verifyDataType, boolean stopAtFirstError, ExtractionContext extractionContext, ExtractionResult extractionResult) {
        RDFParser parser = Rio.createParser((RDFFormat)OWLAPIRDFFormat.MANCHESTER_OWL);
        this.configureParser(parser, verifyDataType, stopAtFirstError, extractionContext, extractionResult);
        return parser;
    }

    public RDFParser getFunctionalSyntaxParser(boolean verifyDataType, boolean stopAtFirstError, ExtractionContext extractionContext, ExtractionResult extractionResult) {
        RDFParser parser = Rio.createParser((RDFFormat)OWLAPIRDFFormat.OWL_FUNCTIONAL);
        this.configureParser(parser, verifyDataType, stopAtFirstError, extractionContext, extractionResult);
        return parser;
    }

    public RDFParser getTriXParser(boolean verifyDataType, boolean stopAtFirstError, ExtractionContext extractionContext, ExtractionResult extractionResult) {
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TRIX);
        this.configureParser(parser, verifyDataType, stopAtFirstError, extractionContext, extractionResult);
        return parser;
    }

    public RDFParser getJSONLDParser(boolean verifyDataType, boolean stopAtFirstError, ExtractionContext extractionContext, ExtractionResult extractionResult) {
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.JSONLD);
        this.configureParser(parser, verifyDataType, stopAtFirstError, extractionContext, extractionResult);
        return parser;
    }

    private void configureParser(RDFParser parser, boolean verifyDataType, boolean stopAtFirstError, ExtractionContext extractionContext, ExtractionResult extractionResult) {
        parser.setDatatypeHandling(verifyDataType ? RDFParser.DatatypeHandling.VERIFY : RDFParser.DatatypeHandling.IGNORE);
        parser.setStopAtFirstError(stopAtFirstError);
        parser.setParseErrorListener((ParseErrorListener)new InternalParseErrorListener((IssueReport)extractionResult));
        parser.setValueFactory((ValueFactory)new Any23ValueFactoryWrapper((ValueFactory)SimpleValueFactory.getInstance(), (IssueReport)extractionResult, extractionContext.getDefaultLanguage()));
        parser.setRDFHandler((RDFHandler)new RDFHandlerAdapter(extractionResult));
    }

    private class ExtendedTurtleParser
    extends TurtleParser {
        private ExtendedTurtleParser() {
        }

        public void parse(Reader reader, String baseIRI) throws IOException, RDFParseException, RDFHandlerException {
            this.setNamespace("", baseIRI);
            super.parse(reader, baseIRI);
        }

        public void parse(InputStream in, String baseIRI) throws IOException, RDFParseException, RDFHandlerException {
            this.setNamespace("", baseIRI);
            super.parse(in, baseIRI);
        }
    }

    private class InternalParseErrorListener
    implements ParseErrorListener {
        private final IssueReport extractionResult;

        public InternalParseErrorListener(IssueReport er) {
            this.extractionResult = er;
        }

        public void warning(String msg, long lineNo, long colNo) {
            try {
                this.extractionResult.notifyIssue(IssueReport.IssueLevel.WARNING, msg, lineNo, colNo);
            }
            catch (Exception e) {
                this.notifyExceptionInNotification(e);
            }
        }

        public void error(String msg, long lineNo, long colNo) {
            try {
                this.extractionResult.notifyIssue(IssueReport.IssueLevel.ERROR, msg, lineNo, colNo);
            }
            catch (Exception e) {
                this.notifyExceptionInNotification(e);
            }
        }

        public void fatalError(String msg, long lineNo, long colNo) {
            try {
                this.extractionResult.notifyIssue(IssueReport.IssueLevel.FATAL, msg, lineNo, colNo);
            }
            catch (Exception e) {
                this.notifyExceptionInNotification(e);
            }
        }

        private void notifyExceptionInNotification(Exception e) {
            if (logger != null) {
                logger.error("An exception occurred while notifying an error.", (Throwable)e);
            }
        }
    }
}

