/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.microdata;

import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.microdata.ItemProp;
import org.apache.any23.extractor.microdata.ItemPropValue;
import org.apache.any23.extractor.microdata.ItemScope;
import org.apache.any23.extractor.microdata.MicrodataParserException;
import org.apache.any23.extractor.microdata.MicrodataParserReport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class MicrodataParser {
    private final Document document;
    private final Set<String> loopDetectorSet = new HashSet<String>();
    private final Map<Node, ItemScope> itemScopes = new HashMap<Node, ItemScope>();
    private final Map<Node, ItemPropValue> itemPropValues = new HashMap<Node, ItemPropValue>();
    private int dereferenceRecursionCounter = 0;
    private ErrorMode errorMode = ErrorMode.FULL_REPORT;
    private List<MicrodataParserException> errors = new ArrayList<MicrodataParserException>();
    public static final String ITEMSCOPE_ATTRIBUTE = "itemscope";
    public static final String ITEMPROP_ATTRIBUTE = "itemprop";
    public static final Set<String> SRC_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("audio", "embed", "frame", "iframe", "img", "source", "track", "video", "input", "layer", "script", "textarea")));
    public static final Set<String> HREF_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("a", "area", "link")));

    public MicrodataParser(Document document) {
        if (document == null) {
            throw new NullPointerException("Document cannot be null.");
        }
        this.document = document;
    }

    public static List<Node> getItemScopeNodes(Node node) {
        return DomUtils.findAllByAttributeName(node, ITEMSCOPE_ATTRIBUTE);
    }

    public static boolean isItemScope(Node node) {
        return DomUtils.readAttribute(node, ITEMSCOPE_ATTRIBUTE, null) != null;
    }

    public static List<Node> getItemPropNodes(Node node) {
        return DomUtils.findAllByAttributeName(node, ITEMPROP_ATTRIBUTE);
    }

    public static boolean isItemProp(Node node) {
        return DomUtils.readAttribute(node, ITEMPROP_ATTRIBUTE, null) != null;
    }

    public static List<Node> getTopLevelItemScopeNodes(Node node) {
        List<Node> itemScopes = MicrodataParser.getItemScopeNodes(node);
        ArrayList<Node> topLevelItemScopes = new ArrayList<Node>();
        for (Node itemScope : itemScopes) {
            if (MicrodataParser.isItemProp(itemScope)) continue;
            topLevelItemScopes.add(itemScope);
        }
        return topLevelItemScopes;
    }

    public static MicrodataParserReport getMicrodata(Document document, ErrorMode errorMode) throws MicrodataParserException {
        List<Node> itemNodes = MicrodataParser.getTopLevelItemScopeNodes(document);
        ArrayList<ItemScope> items = new ArrayList<ItemScope>();
        MicrodataParser microdataParser = new MicrodataParser(document);
        microdataParser.setErrorMode(errorMode);
        for (Node itemNode : itemNodes) {
            items.add(microdataParser.getItemScope(itemNode));
        }
        return new MicrodataParserReport(items.toArray(new ItemScope[items.size()]), microdataParser.getErrors());
    }

    public static MicrodataParserReport getMicrodata(Document document) {
        try {
            return MicrodataParser.getMicrodata(document, ErrorMode.FULL_REPORT);
        }
        catch (MicrodataParserException mpe) {
            throw new IllegalStateException("Unexpected exception.", mpe);
        }
    }

    public static void getMicrodataAsJSON(Document document, PrintStream ps) {
        int i;
        MicrodataParserReport report = MicrodataParser.getMicrodata(document);
        ItemScope[] itemScopes = report.getDetectedItemScopes();
        MicrodataParserException[] errors = report.getErrors();
        ps.append("{ ");
        ps.append("\"result\" : [");
        for (i = 0; i < itemScopes.length; ++i) {
            if (i > 0) {
                ps.print(", ");
            }
            ps.print(itemScopes[i].toJSON());
        }
        ps.append("] ");
        if (errors != null && errors.length > 0) {
            ps.append(", ");
            ps.append("\"errors\" : [");
            for (i = 0; i < errors.length; ++i) {
                if (i > 0) {
                    ps.print(", ");
                }
                ps.print(errors[i].toJSON());
            }
            ps.append("] ");
        }
        ps.append("}");
    }

    private static List<Node> getUnnestedNodes(List<Node> candidates) {
        ArrayList<Node> unnesteds = new ArrayList<Node>();
        for (int i = 0; i < candidates.size(); ++i) {
            boolean skip = false;
            for (int j = 0; j < candidates.size(); ++j) {
                if (i == j || !DomUtils.isAncestorOf(candidates.get(j), candidates.get(i), true)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            unnesteds.add(candidates.get(i));
        }
        return unnesteds;
    }

    public void setErrorMode(ErrorMode errorMode) {
        if (errorMode == null) {
            throw new IllegalArgumentException("errorMode must be not null.");
        }
        this.errorMode = errorMode;
    }

    public ErrorMode getErrorMode() {
        return this.errorMode;
    }

    public MicrodataParserException[] getErrors() {
        return this.errors == null ? new MicrodataParserException[]{} : this.errors.toArray(new MicrodataParserException[this.errors.size()]);
    }

    public ItemPropValue getPropertyValue(Node node) throws MicrodataParserException {
        ItemPropValue itemPropValue = this.itemPropValues.get(node);
        if (itemPropValue != null) {
            return itemPropValue;
        }
        String nodeName = node.getNodeName().toLowerCase();
        if (DomUtils.hasAttribute(node, "content")) {
            return new ItemPropValue(DomUtils.readAttribute(node, "content"), ItemPropValue.Type.Plain);
        }
        if (SRC_TAGS.contains(nodeName)) {
            return new ItemPropValue(DomUtils.readAttribute(node, "src"), ItemPropValue.Type.Link);
        }
        if (HREF_TAGS.contains(nodeName)) {
            return new ItemPropValue(DomUtils.readAttribute(node, "href"), ItemPropValue.Type.Link);
        }
        if ("object".equals(nodeName)) {
            return new ItemPropValue(DomUtils.readAttribute(node, "data"), ItemPropValue.Type.Link);
        }
        if ("time".equals(nodeName)) {
            Date dateTime;
            String dateTimeStr = DomUtils.readAttribute(node, "datetime");
            try {
                dateTime = ItemPropValue.parseDateTime(dateTimeStr);
            }
            catch (ParseException pe) {
                throw new MicrodataParserException(String.format("Invalid format for datetime '%s'", dateTimeStr), node);
            }
            return new ItemPropValue(dateTime, ItemPropValue.Type.Date);
        }
        if (MicrodataParser.isItemScope(node)) {
            return new ItemPropValue(this.getItemScope(node), ItemPropValue.Type.Nested);
        }
        ItemPropValue newItemPropValue = new ItemPropValue(node.getTextContent(), ItemPropValue.Type.Plain);
        this.itemPropValues.put(node, newItemPropValue);
        return newItemPropValue;
    }

    public List<ItemProp> getItemProps(final Node scopeNode, boolean skipRoot) throws MicrodataParserException {
        NamedNodeMap attributes;
        final LinkedHashSet<Node> accepted = new LinkedHashSet<Node>();
        if (!skipRoot && (attributes = scopeNode.getAttributes()).getNamedItem(ITEMPROP_ATTRIBUTE) != null) {
            accepted.add(scopeNode);
        }
        TreeWalker treeWalker = ((DocumentTraversal)((Object)scopeNode.getOwnerDocument())).createTreeWalker(scopeNode, 1, new NodeFilter(){

            @Override
            public short acceptNode(Node node) {
                NamedNodeMap attributes;
                if (node.getNodeType() == 1 && (attributes = node.getAttributes()).getNamedItem(MicrodataParser.ITEMPROP_ATTRIBUTE) != null && !scopeNode.equals(node)) {
                    accepted.add(node);
                }
                return 1;
            }
        }, false);
        while (treeWalker.nextNode() != null) {
        }
        ArrayList<ItemProp> result = new ArrayList<ItemProp>();
        for (Node itemPropNode : accepted) {
            String[] propertyNames;
            String itemProp = DomUtils.readAttribute(itemPropNode, ITEMPROP_ATTRIBUTE, null);
            for (String propertyName : propertyNames = itemProp.split(" ")) {
                ItemPropValue itemPropValue;
                try {
                    itemPropValue = this.getPropertyValue(itemPropNode);
                }
                catch (MicrodataParserException mpe) {
                    this.manageError(mpe);
                    continue;
                }
                result.add(new ItemProp(DomUtils.getXPathForNode(itemPropNode), propertyName, itemPropValue));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemProp[] deferProperties(Node node, String ... refs) throws MicrodataParserException {
        ArrayList<ItemProp> result;
        block10: {
            ++this.dereferenceRecursionCounter;
            result = new ArrayList<ItemProp>();
            try {
                for (String ref : refs) {
                    if (this.loopDetectorSet.contains(ref)) {
                        throw new MicrodataParserException(String.format("Loop detected with depth %d while dereferencing itemProp '%s' .", this.dereferenceRecursionCounter - 1, ref), null);
                    }
                    this.loopDetectorSet.add(ref);
                    Element element = (Element)node;
                    if (element == null) {
                        this.manageError(new MicrodataParserException(String.format("Unknown itemProp id '%s'", ref), null));
                        continue;
                    }
                    List<ItemProp> propList = this.getItemProps(element, false);
                    if (result.containsAll(propList)) continue;
                    result.addAll(propList);
                }
            }
            catch (MicrodataParserException mpe) {
                if (this.dereferenceRecursionCounter == 1) {
                    this.manageError(mpe);
                    break block10;
                }
                throw mpe;
            }
            finally {
                --this.dereferenceRecursionCounter;
                if (this.dereferenceRecursionCounter == 0) {
                    this.loopDetectorSet.clear();
                }
            }
        }
        return result.toArray(new ItemProp[result.size()]);
    }

    public ItemScope getItemScope(Node node) throws MicrodataParserException {
        ItemProp[] deferredProperties;
        ItemScope itemScope = this.itemScopes.get(node);
        if (itemScope != null) {
            return itemScope;
        }
        String id = DomUtils.readAttribute(node, "id", null);
        String itemref = DomUtils.readAttribute(node, "itemref", null);
        String itemType = DomUtils.readAttribute(node, "itemtype", null);
        String itemId = DomUtils.readAttribute(node, "itemid", null);
        List<ItemProp> itemProps = this.getItemProps(node, true);
        String[] itemrefIDs = itemref == null ? new String[]{} : itemref.split(" ");
        try {
            deferredProperties = this.deferProperties(node, itemrefIDs);
        }
        catch (MicrodataParserException mpe) {
            mpe.setErrorNode(node);
            throw mpe;
        }
        for (ItemProp deferredProperty : deferredProperties) {
            if (itemProps.contains(deferredProperty)) {
                this.manageError(new MicrodataParserException(String.format("Duplicated deferred itemProp '%s'.", deferredProperty.getName()), node));
                continue;
            }
            itemProps.add(deferredProperty);
        }
        ItemScope newItemScope = new ItemScope(DomUtils.getXPathForNode(node), itemProps.toArray(new ItemProp[itemProps.size()]), id, itemrefIDs, itemType, itemId);
        this.itemScopes.put(node, newItemScope);
        return newItemScope;
    }

    private void manageError(MicrodataParserException mpe) throws MicrodataParserException {
        if (this.errorMode == ErrorMode.STOP_AT_FIRST_ERROR) {
            throw mpe;
        }
        if (this.errorMode != ErrorMode.FULL_REPORT) {
            throw new IllegalStateException("Unsupported mode " + (Object)((Object)this.errorMode));
        }
        if (this.errors == null) {
            this.errors = new ArrayList<MicrodataParserException>();
        }
        this.errors.add(mpe);
    }

    static enum ErrorMode {
        STOP_AT_FIRST_ERROR,
        FULL_REPORT;

    }
}

