/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html.microformats2;

import java.util.List;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.microformats2.HCardExtractor;
import org.apache.any23.extractor.html.microformats2.HCardExtractorFactory;
import org.apache.any23.extractor.html.microformats2.HProductExtractorFactory;
import org.apache.any23.vocab.HProduct;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HProductExtractor
extends EntityBasedMicroformatExtractor {
    private static final HProduct vProduct = HProduct.getInstance();
    private static final String[] productFields = new String[]{"name", "photo", "brand", "category", "description", "url", "identifier", "review", "price"};

    @Override
    public ExtractorDescription getDescription() {
        return HProductExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "h-product";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        BNode product = this.getBlankNodeFor(node);
        this.conditionallyAddResourceProperty((Resource)product, RDF.TYPE, HProductExtractor.vProduct.product);
        HTMLDocument fragment = new HTMLDocument(node);
        this.addName(fragment, product);
        this.addPhoto(fragment, product);
        this.addCategories(fragment, product);
        this.addDescription(fragment, product);
        this.addURLs(fragment, product);
        this.addIdentifiers(fragment, product);
        this.addPrice(fragment, product);
        this.addBrand(fragment, (Resource)product);
        return true;
    }

    private void mapFieldWithProperty(HTMLDocument fragment, BNode product, String fieldClass, IRI property) {
        HTMLDocument.TextField title = fragment.getSingularTextField(fieldClass);
        this.conditionallyAddStringProperty(title.source(), (Resource)product, property, title.value());
    }

    private void addName(HTMLDocument fragment, BNode product) {
        this.mapFieldWithProperty(fragment, product, "p-" + productFields[0], HProductExtractor.vProduct.name);
    }

    private void addPhoto(HTMLDocument fragment, BNode product) throws ExtractionException {
        HTMLDocument.TextField[] photos;
        for (HTMLDocument.TextField photo : photos = fragment.getPluralUrlField("u-" + productFields[1])) {
            this.addIRIProperty((Resource)product, HProductExtractor.vProduct.photo, fragment.resolveIRI(photo.value()));
        }
    }

    private void addCategories(HTMLDocument fragment, BNode product) {
        HTMLDocument.TextField[] categories;
        for (HTMLDocument.TextField category : categories = fragment.getPluralTextField("p-" + productFields[3])) {
            this.conditionallyAddStringProperty(category.source(), (Resource)product, HProductExtractor.vProduct.category, category.value());
        }
    }

    private void addDescription(HTMLDocument fragment, BNode product) {
        this.mapFieldWithProperty(fragment, product, "e-" + productFields[4], HProductExtractor.vProduct.description);
    }

    private void addURLs(HTMLDocument fragment, BNode product) throws ExtractionException {
        HTMLDocument.TextField[] urls;
        for (HTMLDocument.TextField url : urls = fragment.getPluralUrlField("u-" + productFields[5])) {
            this.addIRIProperty((Resource)product, HProductExtractor.vProduct.url, fragment.resolveIRI(url.value()));
        }
    }

    private void addIdentifiers(HTMLDocument fragment, BNode product) throws ExtractionException {
        HTMLDocument.TextField[] identifiers;
        for (HTMLDocument.TextField identifier : identifiers = fragment.getPluralUrlField("u-" + productFields[6])) {
            this.addIRIProperty((Resource)product, HProductExtractor.vProduct.identifier, fragment.resolveIRI(identifier.value()));
        }
    }

    private void addPrice(HTMLDocument fragment, BNode product) {
        HTMLDocument.TextField price = fragment.getSingularTextField("p-" + productFields[8]);
        if (price.source() == null) {
            return;
        }
        Node attribute = price.source().getAttributes().getNamedItem("value");
        if (attribute == null) {
            this.conditionallyAddStringProperty(price.source(), (Resource)product, HProductExtractor.vProduct.price, price.value());
        } else {
            this.conditionallyAddStringProperty(price.source(), (Resource)product, HProductExtractor.vProduct.price, attribute.getNodeValue());
        }
    }

    private void addBrand(HTMLDocument doc, Resource product) throws ExtractionException {
        List<Node> nodes = doc.findAllByClassName("p-" + productFields[2] + " " + "h-" + "card");
        if (nodes.isEmpty()) {
            return;
        }
        HCardExtractorFactory factory = new HCardExtractorFactory();
        HCardExtractor extractor = factory.createExtractor();
        for (Node node : nodes) {
            BNode brand = this.valueFactory.createBNode();
            this.addIRIProperty((Resource)brand, RDF.TYPE, HProductExtractor.vProduct.brand);
            extractor.extractEntityAsEmbeddedProperty(new HTMLDocument(node), brand, this.getCurrentExtractionResult());
        }
    }
}

