/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.any23.extractor.html.TagSoupParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class DomUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final XPath xPathEngine = XPathFactory.newInstance().newXPath();

    private DomUtils() {
    }

    public static int getIndexInParent(Node n) {
        Node parent = n.getParentNode();
        if (parent == null) {
            return 0;
        }
        NodeList nodes = parent.getChildNodes();
        int counter = -1;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node current = nodes.item(i);
            if (current.getNodeType() == n.getNodeType() && current.getNodeName().equals(n.getNodeName())) {
                ++counter;
            }
            if (!current.equals(n)) continue;
            return counter;
        }
        throw new IllegalStateException("Cannot find a child within its parent node list.");
    }

    public static String getXPathForNode(Node node) {
        StringBuilder sb = new StringBuilder();
        for (Node parent = node; parent != null && parent.getNodeType() != 9; parent = parent.getParentNode()) {
            sb.insert(0, "]");
            sb.insert(0, DomUtils.getIndexInParent(parent) + 1);
            sb.insert(0, "[");
            sb.insert(0, parent.getNodeName());
            sb.insert(0, "/");
        }
        return sb.toString();
    }

    public static String[] getXPathListForNode(Node n) {
        if (n == null) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> ancestors = new ArrayList<String>();
        ancestors.add(String.format("%s[%s]", n.getNodeName(), DomUtils.getIndexInParent(n)));
        for (Node parent = n.getParentNode(); parent != null; parent = parent.getParentNode()) {
            ancestors.add(0, String.format("%s[%s]", parent.getNodeName(), DomUtils.getIndexInParent(parent)));
        }
        return ancestors.toArray(new String[ancestors.size()]);
    }

    public static int[] getNodeLocation(Node n) {
        if (n == null) {
            throw new NullPointerException("node cannot be null.");
        }
        TagSoupParser.ElementLocation elementLocation = (TagSoupParser.ElementLocation)n.getUserData("Element-Location");
        if (elementLocation == null) {
            return null;
        }
        return new int[]{elementLocation.getBeginLineNumber(), elementLocation.getBeginColumnNumber(), elementLocation.getEndLineNumber(), elementLocation.getEndColumnNumber()};
    }

    public static boolean isAncestorOf(Node candidateAncestor, Node candidateSibling, boolean strict) {
        if (candidateAncestor == null) {
            throw new NullPointerException("candidate ancestor cannot be null null.");
        }
        if (candidateSibling == null) {
            throw new NullPointerException("candidate sibling cannot be null null.");
        }
        if (strict && candidateAncestor.equals(candidateSibling)) {
            return false;
        }
        for (Node parent = candidateSibling; parent != null; parent = parent.getParentNode()) {
            if (!parent.equals(candidateAncestor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAncestorOf(Node candidateAncestor, Node candidateSibling) {
        return DomUtils.isAncestorOf(candidateAncestor, candidateSibling, false);
    }

    public static List<Node> findAllByClassName(Node root, String className) {
        return DomUtils.findAllBy(root, null, "class", className.toLowerCase());
    }

    public static List<Node> findAllByAttributeName(Node root, String attrName) {
        return DomUtils.findAllBy(root, null, attrName, null);
    }

    public static List<Node> findAllByAttributeContains(Node node, String attrName, String attrContains) {
        return DomUtils.findAllBy(node, null, attrName, attrContains);
    }

    public static List<Node> findAllByTag(Node root, String tagName) {
        return DomUtils.findAllBy(root, tagName, null, null);
    }

    public static List<Node> findAllByTagAndClassName(Node root, String tagName, String className) {
        return DomUtils.findAllBy(root, tagName, "class", className);
    }

    public static Node findNodeById(Node root, String id) {
        Node node;
        try {
            String xpath = "//*[@id='" + id + "']";
            node = (Node)xPathEngine.evaluate(xpath, root, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException("Should not happen", ex);
        }
        return node;
    }

    public static List<Node> findAll(Node node, String xpath) {
        if (node == null) {
            throw new NullPointerException("node cannot be null.");
        }
        try {
            NodeList nodes = (NodeList)xPathEngine.evaluate(xpath, node, XPathConstants.NODESET);
            ArrayList<Node> result = new ArrayList<Node>(nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                result.add(nodes.item(i));
            }
            return result;
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("Illegal XPath expression: " + xpath, ex);
        }
    }

    public static String find(Node node, String xpath) {
        try {
            String val = (String)xPathEngine.evaluate(xpath, node, XPathConstants.STRING);
            if (null == val) {
                return "";
            }
            return val;
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("Illegal XPath expression: " + xpath, ex);
        }
    }

    public static boolean hasClassName(Node node, String className) {
        return DomUtils.hasAttribute(node, "class", className);
    }

    public static boolean hasAttribute(Node node, String attributeName, String className) {
        String attr = DomUtils.readAttribute(node, attributeName);
        for (String c : attr.split("\\s+")) {
            if (!c.equalsIgnoreCase(className)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAttribute(Node node, String attributeName) {
        return DomUtils.readAttribute(node, attributeName, null) != null;
    }

    public static boolean isElementNode(Node target) {
        return 1 == target.getNodeType();
    }

    public static String readAttribute(Node node, String attribute, String defaultValue) {
        NamedNodeMap attributes = node.getAttributes();
        if (null == attributes) {
            return defaultValue;
        }
        Node attr = attributes.getNamedItem(attribute);
        if (null == attr) {
            return defaultValue;
        }
        return attr.getNodeValue();
    }

    public static String readAttributeWithPrefix(Node node, String attributePrefix, String defaultValue) {
        NamedNodeMap attributes = node.getAttributes();
        if (null == attributes) {
            return defaultValue;
        }
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node attribute = attributes.item(a);
            if (!attribute.getNodeName().startsWith(attributePrefix)) continue;
            return attribute.getNodeValue();
        }
        return defaultValue;
    }

    public static String readAttribute(Node node, String attribute) {
        return DomUtils.readAttribute(node, attribute, "");
    }

    public static String serializeToXML(Node node, boolean indent) throws TransformerException, IOException {
        DOMSource domSource = new DOMSource(node);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        if (indent) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        transformer.transform(domSource, sr);
        sw.close();
        return sw.toString();
    }

    private static List<Node> findAllBy(Node root, final String tagName, final String attrName, String attrContains) {
        DocumentTraversal documentTraversal = (DocumentTraversal)((Object)root.getOwnerDocument());
        if (documentTraversal == null) {
            documentTraversal = (DocumentTraversal)((Object)root);
        }
        final Pattern attrContainsPattern = attrContains != null && !attrContains.equals("*") ? Pattern.compile("(^|\\s)" + attrContains + "(\\s|$)", 2) : null;
        final ArrayList<Node> result = new ArrayList<Node>();
        NodeIterator nodeIterator = documentTraversal.createNodeIterator(root, 1, new NodeFilter(){

            @Override
            public short acceptNode(Node node) {
                if (node.getNodeType() == 1) {
                    if (tagName != null && !tagName.equals("*") && !tagName.equals(node.getNodeName())) {
                        return 1;
                    }
                    if (attrName != null) {
                        Node attrNameNode = node.getAttributes().getNamedItem(attrName);
                        if (attrNameNode == null) {
                            return 1;
                        }
                        if (attrContainsPattern != null && !attrContainsPattern.matcher(attrNameNode.getNodeValue()).find()) {
                            return 1;
                        }
                    }
                    result.add(node);
                }
                return 1;
            }
        }, false);
        while (nodeIterator.nextNode() != null) {
        }
        nodeIterator.detach();
        return result;
    }

    public static InputStream documentToInputStream(Document doc) {
        DOMSource source = new DOMSource(doc);
        StringWriter xmlAsWriter = new StringWriter();
        StreamResult result = new StreamResult(xmlAsWriter);
        try {
            TransformerFactory.newInstance().newTransformer().transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Error within Document to InputStream transformation configuration!");
        }
        catch (TransformerException e) {
            throw new RuntimeException("Error whilst transforming the Document to InputStream!");
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException("Error within Document to InputStream transformation configuration!");
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(xmlAsWriter.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return is;
    }

    public static InputStream nodeToInputStream(Node node) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult outputTarget = new StreamResult(outputStream);
        Transformer t = null;
        try {
            t = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        t.setOutputProperty("omit-xml-declaration", "yes");
        try {
            t.transform(new DOMSource(node), outputTarget);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }
}

