/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.any23.cli.Tool;
import org.apache.any23.extractor.ExampleInputOutput;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorFactory;
import org.apache.any23.extractor.ExtractorRegistry;
import org.apache.any23.extractor.ExtractorRegistryImpl;

@Parameters(commandNames={"extractor"}, commandDescription="Utility for obtaining documentation about metadata extractors.")
public class ExtractorDocumentation
implements Tool {
    @Parameter(names={"-l", "--list"}, description="shows the names of all available extractors")
    private boolean showList;
    @Parameter(names={"-i", "--input"}, description="shows example input for the given extractor")
    private boolean showInput;
    @Parameter(names={"-o", "--outut"}, description="shows example output for the given extractor")
    private boolean showOutput;
    @Parameter(names={"-a", "--all"}, description="shows a report about all available extractors")
    private boolean showAll;
    @Parameter(arity=1, description="Extractor name")
    private List<String> extractor = new LinkedList<String>();

    public void run() throws Exception {
        if (this.showList) {
            this.printExtractorList(ExtractorRegistryImpl.getInstance());
        } else if (this.showInput) {
            if (this.extractor.isEmpty()) {
                throw new IllegalArgumentException("Required argument for -i: extractor name");
            }
            this.printExampleInput(this.extractor.get(0), ExtractorRegistryImpl.getInstance());
        } else if (this.showOutput) {
            if (this.extractor.isEmpty()) {
                throw new IllegalArgumentException("Required argument for -o: extractor name");
            }
            this.printExampleOutput(this.extractor.get(0), ExtractorRegistryImpl.getInstance());
        } else if (this.showAll) {
            this.printReport(ExtractorRegistryImpl.getInstance());
        }
    }

    public void printError(String msg) {
        System.err.println(msg);
    }

    public void printExtractorList(ExtractorRegistry registry) {
        for (ExtractorFactory factory : registry.getExtractorGroup()) {
            System.out.println(String.format("%25s [%15s]", factory.getExtractorName(), factory.getExtractorLabel()));
        }
    }

    public void printExampleInput(String extractorName, ExtractorRegistry registry) throws IOException {
        ExtractorFactory<?> factory = this.getFactory(registry, extractorName);
        ExampleInputOutput example = new ExampleInputOutput(factory);
        String input = example.getExampleInput();
        if (input == null) {
            throw new IllegalArgumentException("Extractor " + extractorName + " provides no example input");
        }
        System.out.println(input);
    }

    public void printExampleOutput(String extractorName, ExtractorRegistry registry) throws IOException, ExtractionException {
        ExtractorFactory<?> factory = this.getFactory(registry, extractorName);
        ExampleInputOutput example = new ExampleInputOutput(factory);
        String output = example.getExampleOutput();
        if (output == null) {
            throw new IllegalArgumentException("Extractor " + extractorName + " provides no example output");
        }
        System.out.println(output);
    }

    public void printReport(ExtractorRegistry registry) throws IOException, ExtractionException {
        for (String extractorName : registry.getAllNames()) {
            ExtractorFactory factory = registry.getFactory(extractorName);
            ExampleInputOutput example = new ExampleInputOutput(factory);
            System.out.println("Extractor: " + extractorName);
            System.out.println("\ttype: " + this.getType(factory));
            System.out.println();
            String exampleInput = example.getExampleInput();
            if (exampleInput == null) {
                System.out.println("(No Example Available)");
            } else {
                System.out.println("-------- Example Input  --------");
                System.out.println(exampleInput);
                System.out.println("-------- Example Output --------");
                String output = example.getExampleOutput();
                System.out.println(output == null || output.trim().length() == 0 ? "(No Output Generated)" : output);
            }
            System.out.println("================================");
            System.out.println();
        }
    }

    private ExtractorFactory<?> getFactory(ExtractorRegistry registry, String name) {
        if (!registry.isRegisteredName(name)) {
            throw new IllegalArgumentException("Unknown extractor name: " + name);
        }
        return registry.getFactory(name);
    }

    private String getType(ExtractorFactory<?> factory) {
        Extractor extractor = factory.createExtractor();
        if (extractor instanceof Extractor.BlindExtractor) {
            return Extractor.BlindExtractor.class.getSimpleName();
        }
        if (extractor instanceof Extractor.TagSoupDOMExtractor) {
            return Extractor.TagSoupDOMExtractor.class.getSimpleName();
        }
        if (extractor instanceof Extractor.ContentExtractor) {
            return Extractor.ContentExtractor.class.getSimpleName();
        }
        return "?";
    }
}

