/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.inject.assistedinject.Assisted;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.ChangeDetails;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import uk.ac.manchester.cs.owl.owlapi.OWLImmutableOntologyImpl;

public class OWLOntologyImpl
extends OWLImmutableOntologyImpl
implements OWLMutableOntology,
Serializable {
    @Inject
    public OWLOntologyImpl(@Assisted OWLOntologyManager manager, @Assisted OWLOntologyID ontologyID) {
        super(manager, ontologyID);
    }

    public ChangeApplied applyDirectChange(OWLOntologyChange change) {
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        return (ChangeApplied)change.accept((OWLOntologyChangeVisitorEx)changeFilter);
    }

    public ChangeDetails applyChangesAndGetDetails(List<? extends OWLOntologyChange> changes) {
        ArrayList<OWLOntologyChange> enactedChanges = new ArrayList<OWLOntologyChange>();
        ChangeApplied appliedChanges = ChangeApplied.SUCCESSFULLY;
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            ChangeApplied result = (ChangeApplied)oWLOntologyChange.accept((OWLOntologyChangeVisitorEx)changeFilter);
            if (result == ChangeApplied.SUCCESSFULLY) {
                enactedChanges.add(oWLOntologyChange);
            }
            if (appliedChanges != ChangeApplied.SUCCESSFULLY) continue;
            appliedChanges = result;
        }
        return new ChangeDetails(appliedChanges, enactedChanges);
    }

    protected class OWLOntologyChangeFilter
    implements OWLOntologyChangeVisitorEx<ChangeApplied>,
    Serializable {
        protected OWLOntologyChangeFilter() {
        }

        public ChangeApplied visit(RemoveAxiom change) {
            if (OWLOntologyImpl.this.ints.removeAxiom(change.getAxiom())) {
                OWLImmutableOntologyImpl.invalidateOntologyCaches(OWLOntologyImpl.this);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(SetOntologyID change) {
            OWLOntologyID id = change.getNewOntologyID();
            if (!id.equals((Object)OWLOntologyImpl.this.ontologyID)) {
                OWLOntologyImpl.this.hashCode = 0;
                OWLOntologyImpl.this.ontologyID = id;
                OWLImmutableOntologyImpl.invalidateOntologyCaches(OWLOntologyImpl.this);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(AddAxiom change) {
            if (OWLOntologyImpl.this.ints.addAxiom(change.getAxiom())) {
                OWLImmutableOntologyImpl.invalidateOntologyCaches(OWLOntologyImpl.this);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(AddImport change) {
            if (OWLOntologyImpl.this.ints.addImportsDeclaration(change.getImportDeclaration())) {
                OWLImmutableOntologyImpl.invalidateOntologyCaches(OWLOntologyImpl.this);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(RemoveImport change) {
            if (OWLOntologyImpl.this.ints.removeImportsDeclaration(change.getImportDeclaration())) {
                OWLImmutableOntologyImpl.invalidateOntologyCaches(OWLOntologyImpl.this);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(AddOntologyAnnotation change) {
            if (OWLOntologyImpl.this.ints.addOntologyAnnotation(change.getAnnotation())) {
                OWLImmutableOntologyImpl.invalidateOntologyCaches(OWLOntologyImpl.this);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(RemoveOntologyAnnotation change) {
            if (OWLOntologyImpl.this.ints.removeOntologyAnnotation(change.getAnnotation())) {
                OWLImmutableOntologyImpl.invalidateOntologyCaches(OWLOntologyImpl.this);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }
    }
}

