/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.providers.ClassProvider;
import org.semanticweb.owlapi.model.providers.DatatypeProvider;
import org.semanticweb.owlapi.model.providers.EntityProvider;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.CompressionEnabled;
import uk.ac.manchester.cs.owl.owlapi.InternalizedEntities;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImplNotAnnotated;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyDomainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyRangeAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnonymousIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAsymmetricObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataAllValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataComplementOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataExactCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternals;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternalsImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataHasValueImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataIntersectionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataMaxCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataMinCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataOneOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyDomainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyRangeAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataSomeValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataUnionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeDefinitionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeRestrictionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDeclarationAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDifferentIndividualsAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointDataPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointObjectPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointUnionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentDataPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentObjectPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLFacetRestrictionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLFunctionalDataPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLFunctionalObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLHasKeyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLImportsDeclarationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLInverseFunctionalObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLInverseObjectPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLIrreflexiveObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNegativeDataPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNegativeObjectPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectAllValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectComplementOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectExactCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectHasSelfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectHasValueImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectIntersectionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectInverseOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectMaxCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectMinCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectOneOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyDomainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyRangeAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectSomeValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectUnionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLReflexiveObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSameIndividualAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubAnnotationPropertyOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubClassOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubDataPropertyOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubObjectPropertyOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubPropertyChainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSymmetricObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLTransitiveObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLBuiltInAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLClassAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLDataPropertyAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLDataRangeAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLDifferentIndividualsAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLIndividualArgumentImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLLiteralArgumentImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLObjectPropertyAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLRuleImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLSameIndividualAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLVariableImpl;

public class OWLDataFactoryImpl
implements OWLDataFactory,
Serializable,
ClassProvider {
    private final boolean useCompression;
    private transient OWLDataFactoryInternals dataFactoryInternals;

    public OWLDataFactoryImpl() {
        this(false);
    }

    @Inject
    public OWLDataFactoryImpl(@CompressionEnabled boolean useCompression) {
        this.useCompression = useCompression;
        this.dataFactoryInternals = new OWLDataFactoryInternalsImpl(this.useCompression);
    }

    private static void checkAnnotations(Collection<OWLAnnotation> o) {
        OWLAPIPreconditions.checkIterableNotNull(o, (String)"annotations cannot be null", (boolean)true);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.dataFactoryInternals = new OWLDataFactoryInternalsImpl(this.useCompression);
    }

    public void purge() {
        this.dataFactoryInternals.purge();
    }

    public <E extends OWLEntity> E getOWLEntity(EntityType<E> entityType, IRI iri) {
        OWLAPIPreconditions.checkNotNull(entityType, (String)"entityType cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
        return (E)entityType.buildEntity(iri, (EntityProvider)this);
    }

    public OWLClass getOWLClass(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
        return this.dataFactoryInternals.getOWLClass(iri);
    }

    public OWLAnnotationProperty getRDFSLabel() {
        return InternalizedEntities.RDFS_LABEL;
    }

    public OWLAnnotationProperty getRDFSComment() {
        return InternalizedEntities.RDFS_COMMENT;
    }

    public OWLAnnotationProperty getRDFSSeeAlso() {
        return InternalizedEntities.RDFS_SEE_ALSO;
    }

    public OWLAnnotationProperty getRDFSIsDefinedBy() {
        return InternalizedEntities.RDFS_IS_DEFINED_BY;
    }

    public OWLAnnotationProperty getOWLVersionInfo() {
        return InternalizedEntities.OWL_VERSION_INFO;
    }

    public OWLAnnotationProperty getOWLBackwardCompatibleWith() {
        return InternalizedEntities.OWL_BACKWARD_COMPATIBLE_WITH;
    }

    public OWLAnnotationProperty getOWLIncompatibleWith() {
        return InternalizedEntities.OWL_INCOMPATIBLE_WITH;
    }

    public OWLAnnotationProperty getOWLDeprecated() {
        return InternalizedEntities.OWL_DEPRECATED;
    }

    public OWLClass getOWLThing() {
        return InternalizedEntities.OWL_THING;
    }

    public OWLClass getOWLNothing() {
        return InternalizedEntities.OWL_NOTHING;
    }

    public OWLDataProperty getOWLBottomDataProperty() {
        return InternalizedEntities.OWL_BOTTOM_DATA_PROPERTY;
    }

    public OWLObjectProperty getOWLBottomObjectProperty() {
        return InternalizedEntities.OWL_BOTTOM_OBJECT_PROPERTY;
    }

    public OWLDataProperty getOWLTopDataProperty() {
        return InternalizedEntities.OWL_TOP_DATA_PROPERTY;
    }

    public OWLObjectProperty getOWLTopObjectProperty() {
        return InternalizedEntities.OWL_TOP_OBJECT_PROPERTY;
    }

    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
        return this.dataFactoryInternals.getOWLObjectProperty(iri);
    }

    public OWLDataProperty getOWLDataProperty(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
        return this.dataFactoryInternals.getOWLDataProperty(iri);
    }

    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
        return this.dataFactoryInternals.getOWLNamedIndividual(iri);
    }

    public OWLAnonymousIndividual getOWLAnonymousIndividual(String nodeId) {
        OWLAPIPreconditions.checkNotNull((Object)nodeId, (String)"id cannot be null");
        return new OWLAnonymousIndividualImpl(NodeID.getNodeID((String)nodeId));
    }

    public OWLAnonymousIndividual getOWLAnonymousIndividual() {
        return new OWLAnonymousIndividualImpl(NodeID.getNodeID(null));
    }

    public OWLDatatype getOWLDatatype(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
        return this.dataFactoryInternals.getOWLDatatype(iri);
    }

    public OWLLiteral getOWLLiteral(boolean value) {
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    public OWLDataOneOf getOWLDataOneOf(Stream<? extends OWLLiteral> values) {
        return new OWLDataOneOfImpl(values);
    }

    public OWLDataComplementOf getOWLDataComplementOf(OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)"dataRange cannot be null");
        return new OWLDataComplementOfImpl(dataRange);
    }

    public OWLDataComplementOf getOWLDataComplementOf(OWL2Datatype dataRange) {
        return this.getOWLDataComplementOf((OWLDataRange)dataRange.getDatatype((DatatypeProvider)this));
    }

    public OWLDataIntersectionOf getOWLDataIntersectionOf(Stream<? extends OWLDataRange> dataRanges) {
        return new OWLDataIntersectionOfImpl(dataRanges.map(x -> x));
    }

    public OWLDataUnionOf getOWLDataUnionOf(Stream<? extends OWLDataRange> dataRanges) {
        return new OWLDataUnionOfImpl(dataRanges.map(x -> x));
    }

    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype dataType, Collection<OWLFacetRestriction> facetRestrictions) {
        OWLAPIPreconditions.checkNotNull((Object)dataType, (String)"datatype cannot be null");
        OWLAPIPreconditions.checkIterableNotNull(facetRestrictions, (String)"facets", (boolean)true);
        return new OWLDatatypeRestrictionImpl(dataType, facetRestrictions);
    }

    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype dataType, OWLFacet facet, OWLLiteral typedLiteral) {
        OWLAPIPreconditions.checkNotNull((Object)dataType, (String)"datatype cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)facet, (String)"facet cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)typedLiteral, (String)"typedConstant cannot be null");
        return new OWLDatatypeRestrictionImpl(dataType, CollectionFactory.createSet((Object)this.getOWLFacetRestriction(facet, typedLiteral)));
    }

    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, OWLLiteral facetValue) {
        OWLAPIPreconditions.checkNotNull((Object)facet, (String)"facet cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)facetValue, (String)"facetValue cannot be null");
        return new OWLFacetRestrictionImpl(facet, facetValue);
    }

    public OWLObjectIntersectionOf getOWLObjectIntersectionOf(Stream<? extends OWLClassExpression> operands) {
        return new OWLObjectIntersectionOfImpl(operands.map(x -> x));
    }

    public OWLObjectIntersectionOf getOWLObjectIntersectionOf(Collection<? extends OWLClassExpression> operands) {
        return new OWLObjectIntersectionOfImpl(operands);
    }

    public OWLDataAllValuesFrom getOWLDataAllValuesFrom(OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)"dataRange cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLDataAllValuesFromImpl(property, dataRange);
    }

    public OWLDataAllValuesFrom getOWLDataAllValuesFrom(OWLDataPropertyExpression property, OWL2Datatype dataRange) {
        return this.getOWLDataAllValuesFrom(property, (OWLDataRange)dataRange.getDatatype((DatatypeProvider)this));
    }

    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)"cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLDataExactCardinalityImpl(property, cardinality, (OWLDataRange)this.getTopDatatype());
    }

    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)"dataRange cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)"cardinality cannot be negative");
        return new OWLDataExactCardinalityImpl(property, cardinality, dataRange);
    }

    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property, OWL2Datatype dataRange) {
        return this.getOWLDataExactCardinality(cardinality, property, (OWLDataRange)dataRange.getDatatype((DatatypeProvider)this));
    }

    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)"cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLDataMaxCardinalityImpl(property, cardinality, (OWLDataRange)this.getTopDatatype());
    }

    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)"cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)"dataRange cannot be null");
        return new OWLDataMaxCardinalityImpl(property, cardinality, dataRange);
    }

    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property, OWL2Datatype dataRange) {
        return this.getOWLDataMaxCardinality(cardinality, property, (OWLDataRange)dataRange.getDatatype((DatatypeProvider)this));
    }

    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)"cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLDataMinCardinalityImpl(property, cardinality, (OWLDataRange)this.getTopDatatype());
    }

    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)"dataRange cannot be null");
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)"cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLDataMinCardinalityImpl(property, cardinality, dataRange);
    }

    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property, OWL2Datatype dataRange) {
        return this.getOWLDataMinCardinality(cardinality, property, (OWLDataRange)dataRange.getDatatype((DatatypeProvider)this));
    }

    public OWLDataSomeValuesFrom getOWLDataSomeValuesFrom(OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)"dataRange cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLDataSomeValuesFromImpl(property, dataRange);
    }

    public OWLDataSomeValuesFrom getOWLDataSomeValuesFrom(OWLDataPropertyExpression property, OWL2Datatype dataRange) {
        return this.getOWLDataSomeValuesFrom(property, (OWLDataRange)dataRange.getDatatype((DatatypeProvider)this));
    }

    public OWLDataHasValue getOWLDataHasValue(OWLDataPropertyExpression property, OWLLiteral value) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)value, (String)"value cannot be null");
        return new OWLDataHasValueImpl(property, value);
    }

    public OWLObjectComplementOf getOWLObjectComplementOf(OWLClassExpression operand) {
        OWLAPIPreconditions.checkNotNull((Object)operand, (String)"operand");
        return new OWLObjectComplementOfImpl(operand);
    }

    public OWLObjectAllValuesFrom getOWLObjectAllValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)"classExpression cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLObjectAllValuesFromImpl(property, classExpression);
    }

    public OWLObjectOneOf getOWLObjectOneOf(Stream<? extends OWLIndividual> values) {
        return new OWLObjectOneOfImpl(values.map(x -> x));
    }

    public OWLObjectExactCardinality getOWLObjectExactCardinality(int cardinality, OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)"cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLObjectExactCardinalityImpl(property, cardinality, (OWLClassExpression)InternalizedEntities.OWL_THING);
    }

    public OWLObjectExactCardinality getOWLObjectExactCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)"classExpression cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)"cardinality cannot be negative");
        return new OWLObjectExactCardinalityImpl(property, cardinality, classExpression);
    }

    public OWLObjectMinCardinality getOWLObjectMinCardinality(int cardinality, OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)"cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLObjectMinCardinalityImpl(property, cardinality, (OWLClassExpression)InternalizedEntities.OWL_THING);
    }

    public OWLObjectMinCardinality getOWLObjectMinCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)"classExpression cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)"cardinality cannot be negative");
        return new OWLObjectMinCardinalityImpl(property, cardinality, classExpression);
    }

    public OWLObjectMaxCardinality getOWLObjectMaxCardinality(int cardinality, OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)"cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLObjectMaxCardinalityImpl(property, cardinality, (OWLClassExpression)InternalizedEntities.OWL_THING);
    }

    public OWLObjectMaxCardinality getOWLObjectMaxCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)"cardinality cannot be negative");
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)"classExpression cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLObjectMaxCardinalityImpl(property, cardinality, classExpression);
    }

    public OWLObjectHasSelf getOWLObjectHasSelf(OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLObjectHasSelfImpl(property);
    }

    public OWLObjectSomeValuesFrom getOWLObjectSomeValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)"classExpression cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLObjectSomeValuesFromImpl(property, classExpression);
    }

    public OWLObjectHasValue getOWLObjectHasValue(OWLObjectPropertyExpression property, OWLIndividual individual) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)individual, (String)"individual cannot be null");
        return new OWLObjectHasValueImpl(property, individual);
    }

    public OWLObjectUnionOf getOWLObjectUnionOf(Stream<? extends OWLClassExpression> operands) {
        return new OWLObjectUnionOfImpl(operands.map(x -> x));
    }

    public OWLObjectUnionOf getOWLObjectUnionOf(Collection<? extends OWLClassExpression> operands) {
        return new OWLObjectUnionOfImpl(operands);
    }

    public OWLAsymmetricObjectPropertyAxiom getOWLAsymmetricObjectPropertyAxiom(OWLObjectPropertyExpression propertyExpression, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)propertyExpression, (String)"property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLAsymmetricObjectPropertyAxiomImpl(propertyExpression, annotations);
    }

    public OWLDataPropertyDomainAxiom getOWLDataPropertyDomainAxiom(OWLDataPropertyExpression property, OWLClassExpression domain, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)domain, (String)"domain cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDataPropertyDomainAxiomImpl(property, domain, annotations);
    }

    public OWLDataPropertyRangeAxiom getOWLDataPropertyRangeAxiom(OWLDataPropertyExpression property, OWLDataRange owlDataRange, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)owlDataRange, (String)"owlDataRange cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDataPropertyRangeAxiomImpl(property, owlDataRange, annotations);
    }

    public OWLDataPropertyRangeAxiom getOWLDataPropertyRangeAxiom(OWLDataPropertyExpression property, OWL2Datatype owlDataRange, Collection<OWLAnnotation> annotations) {
        return this.getOWLDataPropertyRangeAxiom(property, (OWLDataRange)owlDataRange.getDatatype((DatatypeProvider)this), annotations);
    }

    public OWLSubDataPropertyOfAxiom getOWLSubDataPropertyOfAxiom(OWLDataPropertyExpression subProperty, OWLDataPropertyExpression superProperty, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)subProperty, (String)"subProperty cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)superProperty, (String)"superProperty cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubDataPropertyOfAxiomImpl(subProperty, superProperty, annotations);
    }

    public OWLDeclarationAxiom getOWLDeclarationAxiom(OWLEntity owlEntity, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)owlEntity, (String)"owlEntity cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDeclarationAxiomImpl(owlEntity, annotations);
    }

    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(Collection<? extends OWLIndividual> individuals, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkIterableNotNull(individuals, (String)"individuals cannot be null", (boolean)true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDifferentIndividualsAxiomImpl(individuals, annotations);
    }

    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(Collection<? extends OWLClassExpression> classExpressions, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkIterableNotNull(classExpressions, (String)"classExpressions cannot be null or contain null", (boolean)true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        if (classExpressions.size() == 1) {
            HashSet<Object> modifiedClassExpressions = new HashSet<Object>(2);
            OWLClassExpression classExpression = classExpressions.iterator().next();
            OWLClass addedClass = classExpression.isOWLThing() ? InternalizedEntities.OWL_NOTHING : InternalizedEntities.OWL_THING;
            modifiedClassExpressions.add(addedClass);
            modifiedClassExpressions.add(classExpression);
            return this.getOWLDisjointClassesAxiom(modifiedClassExpressions, this.makeSingletonDisjoinClassWarningAnnotation(annotations, classExpression, (OWLClassExpression)addedClass));
        }
        return new OWLDisjointClassesAxiomImpl(classExpressions, annotations);
    }

    protected Set<OWLAnnotation> makeSingletonDisjoinClassWarningAnnotation(Collection<OWLAnnotation> annotations, OWLClassExpression classExpression, OWLClassExpression addedClass) {
        HashSet<OWLAnnotation> modifiedAnnotations = new HashSet<OWLAnnotation>(annotations.size() + 1);
        modifiedAnnotations.addAll(annotations);
        String provenanceComment = String.format("%s on %s", VersionInfo.getVersionInfo().getGeneratedByMessage(), new SimpleDateFormat().format(new Date()));
        OWLAnnotation provenanceAnnotation = this.getOWLAnnotation(InternalizedEntities.RDFS_COMMENT, (OWLAnnotationValue)this.getOWLLiteral(provenanceComment));
        Set<OWLAnnotation> metaAnnotations = Collections.singleton(provenanceAnnotation);
        String changeComment = String.format("DisjointClasses(%s) replaced by DisjointClasses(%s %s)", classExpression, classExpression, addedClass);
        modifiedAnnotations.add(this.getOWLAnnotation(InternalizedEntities.RDFS_COMMENT, (OWLAnnotationValue)this.getOWLLiteral(changeComment), metaAnnotations));
        return modifiedAnnotations;
    }

    public OWLDisjointDataPropertiesAxiom getOWLDisjointDataPropertiesAxiom(Collection<? extends OWLDataPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkIterableNotNull(properties, (String)"properties cannot be null", (boolean)true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDisjointDataPropertiesAxiomImpl(properties, annotations);
    }

    public OWLDisjointObjectPropertiesAxiom getOWLDisjointObjectPropertiesAxiom(Collection<? extends OWLObjectPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkIterableNotNull(properties, (String)"properties cannot be null", (boolean)true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDisjointObjectPropertiesAxiomImpl(properties, annotations);
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(Collection<? extends OWLClassExpression> classExpressions, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkIterableNotNull(classExpressions, (String)"classExpressions cannot be null", (boolean)true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLEquivalentClassesAxiomImpl(classExpressions, annotations);
    }

    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(Collection<? extends OWLDataPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkIterableNotNull(properties, (String)"properties cannot be null", (boolean)true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLEquivalentDataPropertiesAxiomImpl(properties, annotations);
    }

    public OWLFunctionalDataPropertyAxiom getOWLFunctionalDataPropertyAxiom(OWLDataPropertyExpression property, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLFunctionalDataPropertyAxiomImpl(property, annotations);
    }

    public OWLFunctionalObjectPropertyAxiom getOWLFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLFunctionalObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLImportsDeclaration getOWLImportsDeclaration(IRI importedOntologyIRI) {
        OWLAPIPreconditions.checkNotNull((Object)importedOntologyIRI, (String)"importedOntologyIRI cannot be null");
        return new OWLImportsDeclarationImpl(importedOntologyIRI);
    }

    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)object, (String)"object cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)subject, (String)"subject cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDataPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    public OWLNegativeDataPropertyAssertionAxiom getOWLNegativeDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)object, (String)"object cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)subject, (String)"subject cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLNegativeDataPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    public OWLNegativeObjectPropertyAssertionAxiom getOWLNegativeObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual subject, OWLIndividual object, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)object, (String)"object cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)subject, (String)"subject cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLNegativeObjectPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    public OWLClassAssertionAxiom getOWLClassAssertionAxiom(OWLClassExpression classExpression, OWLIndividual individual, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)"classExpression cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)individual, (String)"individual cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLClassAssertionAxiomImpl(individual, classExpression, annotations);
    }

    public OWLInverseFunctionalObjectPropertyAxiom getOWLInverseFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLInverseFunctionalObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLIrreflexiveObjectPropertyAxiom getOWLIrreflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLIrreflexiveObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLObjectPropertyDomainAxiom getOWLObjectPropertyDomainAxiom(OWLObjectPropertyExpression property, OWLClassExpression classExpression, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)"classExpression cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLObjectPropertyDomainAxiomImpl(property, classExpression, annotations);
    }

    public OWLObjectPropertyRangeAxiom getOWLObjectPropertyRangeAxiom(OWLObjectPropertyExpression property, OWLClassExpression range, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)range, (String)"range cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLObjectPropertyRangeAxiomImpl(property, range, annotations);
    }

    public OWLSubObjectPropertyOfAxiom getOWLSubObjectPropertyOfAxiom(OWLObjectPropertyExpression subProperty, OWLObjectPropertyExpression superProperty, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)subProperty, (String)"subProperty cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)superProperty, (String)"superProperty cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubObjectPropertyOfAxiomImpl(subProperty, superProperty, annotations);
    }

    public OWLReflexiveObjectPropertyAxiom getOWLReflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLReflexiveObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLSameIndividualAxiom getOWLSameIndividualAxiom(Collection<? extends OWLIndividual> individuals, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkIterableNotNull(individuals, (String)"individuals cannot be null", (boolean)true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSameIndividualAxiomImpl(individuals, annotations);
    }

    public OWLSubClassOfAxiom getOWLSubClassOfAxiom(OWLClassExpression subClass, OWLClassExpression superClass, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)subClass, (String)"subclass cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)superClass, (String)"superclass cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubClassOfAxiomImpl(subClass, superClass, annotations);
    }

    public OWLSymmetricObjectPropertyAxiom getOWLSymmetricObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSymmetricObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLTransitiveObjectPropertyAxiom getOWLTransitiveObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLTransitiveObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLObjectInverseOf getOWLObjectInverseOf(OWLObjectProperty property) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        return new OWLObjectInverseOfImpl(property);
    }

    public OWLInverseObjectPropertiesAxiom getOWLInverseObjectPropertiesAxiom(OWLObjectPropertyExpression forwardProperty, OWLObjectPropertyExpression inverseProperty, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)forwardProperty, (String)"forwardProperty cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)inverseProperty, (String)"inverseProperty cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLInverseObjectPropertiesAxiomImpl(forwardProperty, inverseProperty, annotations);
    }

    public OWLSubPropertyChainOfAxiom getOWLSubPropertyChainOfAxiom(List<? extends OWLObjectPropertyExpression> chain, OWLObjectPropertyExpression superProperty, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)superProperty, (String)"superProperty cannot be null");
        OWLAPIPreconditions.checkIterableNotNull(chain, (String)"chain cannot be null", (boolean)true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubPropertyChainAxiomImpl(chain, superProperty, annotations);
    }

    public OWLHasKeyAxiom getOWLHasKeyAxiom(OWLClassExpression ce, Collection<? extends OWLPropertyExpression> objectProperties, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)ce, (String)"classExpression cannot be null");
        OWLAPIPreconditions.checkIterableNotNull(objectProperties, (String)"properties cannot be null", (boolean)true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLHasKeyAxiomImpl(ce, objectProperties, annotations);
    }

    public OWLDisjointUnionAxiom getOWLDisjointUnionAxiom(OWLClass owlClass, Stream<? extends OWLClassExpression> classExpressions, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)owlClass, (String)"owlClass cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDisjointUnionAxiomImpl(owlClass, classExpressions.map(x -> x), annotations);
    }

    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(Collection<? extends OWLObjectPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkIterableNotNull(properties, (String)"properties cannot be null", (boolean)true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLEquivalentObjectPropertiesAxiomImpl(properties, annotations);
    }

    public OWLObjectPropertyAssertionAxiom getOWLObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual individual, OWLIndividual object, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)individual, (String)"individual cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)object, (String)"object cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLObjectPropertyAssertionAxiomImpl(individual, property, object, annotations);
    }

    public OWLSubAnnotationPropertyOfAxiom getOWLSubAnnotationPropertyOfAxiom(OWLAnnotationProperty sub, OWLAnnotationProperty sup, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)sub, (String)"subProperty cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)sup, (String)"superProperty cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubAnnotationPropertyOfAxiomImpl(sub, sup, annotations);
    }

    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
        return this.dataFactoryInternals.getOWLAnnotationProperty(iri);
    }

    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value) {
        return new OWLAnnotationImplNotAnnotated(property, value);
    }

    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, Stream<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)value, (String)"value cannot be null");
        OWLAPIPreconditions.checkNotNull(annotations, (String)"annotations cannot be null");
        return this.dataFactoryInternals.getOWLAnnotation(property, value, annotations);
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationSubject subject, OWLAnnotation annotation) {
        OWLAPIPreconditions.checkNotNull((Object)annotation, (String)"annotation cannot be null");
        return this.getOWLAnnotationAssertionAxiom(annotation.getProperty(), subject, annotation.getValue(), OWLAPIStreamUtils.asList((Stream)annotation.annotations()));
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationSubject subject, OWLAnnotation annotation, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)annotation, (String)"annotation cannot be null");
        return this.getOWLAnnotationAssertionAxiom(annotation.getProperty(), subject, annotation.getValue(), annotations);
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationProperty property, OWLAnnotationSubject subject, OWLAnnotationValue value, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)subject, (String)"subject cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)value, (String)"value cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLAnnotationAssertionAxiomImpl(subject, property, value, annotations);
    }

    public OWLAnnotationAssertionAxiom getDeprecatedOWLAnnotationAssertionAxiom(IRI subject) {
        OWLAPIPreconditions.checkNotNull((Object)subject, (String)"subject cannot be null");
        return this.getOWLAnnotationAssertionAxiom(this.getOWLDeprecated(), (OWLAnnotationSubject)subject, (OWLAnnotationValue)this.getOWLLiteral(true));
    }

    public OWLAnnotationPropertyDomainAxiom getOWLAnnotationPropertyDomainAxiom(OWLAnnotationProperty prop, IRI domain, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)prop, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)domain, (String)"domain cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLAnnotationPropertyDomainAxiomImpl(prop, domain, annotations);
    }

    public OWLAnnotationPropertyRangeAxiom getOWLAnnotationPropertyRangeAxiom(OWLAnnotationProperty prop, IRI range, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)prop, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)range, (String)"range cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLAnnotationPropertyRangeAxiomImpl(prop, range, annotations);
    }

    public SWRLRule getSWRLRule(Collection<? extends SWRLAtom> body, Collection<? extends SWRLAtom> head, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkIterableNotNull(body, (String)"body cannot be null", (boolean)true);
        OWLAPIPreconditions.checkIterableNotNull(head, (String)"head cannot be null", (boolean)true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new SWRLRuleImpl(body, head, annotations);
    }

    public SWRLRule getSWRLRule(Collection<? extends SWRLAtom> body, Collection<? extends SWRLAtom> head) {
        OWLAPIPreconditions.checkIterableNotNull(body, (String)"antecedent cannot be null", (boolean)true);
        OWLAPIPreconditions.checkIterableNotNull(head, (String)"consequent cannot be null", (boolean)true);
        return new SWRLRuleImpl(body, head);
    }

    public SWRLClassAtom getSWRLClassAtom(OWLClassExpression predicate, SWRLIArgument arg) {
        OWLAPIPreconditions.checkNotNull((Object)predicate, (String)"predicate cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)arg, (String)"arg cannot be null");
        return new SWRLClassAtomImpl(predicate, arg);
    }

    public SWRLDataRangeAtom getSWRLDataRangeAtom(OWLDataRange predicate, SWRLDArgument arg) {
        OWLAPIPreconditions.checkNotNull((Object)predicate, (String)"predicate cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)arg, (String)"arg cannot be null");
        return new SWRLDataRangeAtomImpl(predicate, arg);
    }

    public SWRLDataRangeAtom getSWRLDataRangeAtom(OWL2Datatype predicate, SWRLDArgument arg) {
        return this.getSWRLDataRangeAtom((OWLDataRange)predicate.getDatatype((DatatypeProvider)this), arg);
    }

    public SWRLObjectPropertyAtom getSWRLObjectPropertyAtom(OWLObjectPropertyExpression property, SWRLIArgument arg0, SWRLIArgument arg1) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)arg0, (String)"arg0 cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)arg1, (String)"arg1 cannot be null");
        return new SWRLObjectPropertyAtomImpl(property, arg0, arg1);
    }

    public SWRLDataPropertyAtom getSWRLDataPropertyAtom(OWLDataPropertyExpression property, SWRLIArgument arg0, SWRLDArgument arg1) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)arg0, (String)"arg0 cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)arg1, (String)"arg1 cannot be null");
        return new SWRLDataPropertyAtomImpl(property, arg0, arg1);
    }

    public SWRLBuiltInAtom getSWRLBuiltInAtom(IRI builtInIRI, List<SWRLDArgument> args) {
        OWLAPIPreconditions.checkNotNull((Object)builtInIRI, (String)"builtInIRI cannot be null");
        OWLAPIPreconditions.checkNotNull(args, (String)"args cannot be null");
        return new SWRLBuiltInAtomImpl(builtInIRI, args);
    }

    public SWRLVariable getSWRLVariable(IRI var) {
        OWLAPIPreconditions.checkNotNull((Object)var, (String)"var cannot be null");
        return new SWRLVariableImpl(var);
    }

    public SWRLIndividualArgument getSWRLIndividualArgument(OWLIndividual individual) {
        OWLAPIPreconditions.checkNotNull((Object)individual, (String)"individual cannot be null");
        return new SWRLIndividualArgumentImpl(individual);
    }

    public SWRLLiteralArgument getSWRLLiteralArgument(OWLLiteral literal) {
        OWLAPIPreconditions.checkNotNull((Object)literal, (String)"literal");
        return new SWRLLiteralArgumentImpl(literal);
    }

    public SWRLDifferentIndividualsAtom getSWRLDifferentIndividualsAtom(SWRLIArgument arg0, SWRLIArgument arg1) {
        OWLAPIPreconditions.checkNotNull((Object)arg0, (String)"arg0 cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)arg1, (String)"arg1 cannot be null");
        return new SWRLDifferentIndividualsAtomImpl(this.getOWLObjectProperty((HasIRI)OWLRDFVocabulary.OWL_DIFFERENT_FROM), arg0, arg1);
    }

    public SWRLSameIndividualAtom getSWRLSameIndividualAtom(SWRLIArgument arg0, SWRLIArgument arg1) {
        OWLAPIPreconditions.checkNotNull((Object)arg0, (String)"arg0 cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)arg1, (String)"arg1 cannot be null");
        return new SWRLSameIndividualAtomImpl(this.getOWLObjectProperty((HasIRI)OWLRDFVocabulary.OWL_SAME_AS), arg0, arg1);
    }

    public OWLDatatypeDefinitionAxiom getOWLDatatypeDefinitionAxiom(OWLDatatype datatype, OWLDataRange dataRange, Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)datatype, (String)"datatype cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)"dataRange cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDatatypeDefinitionAxiomImpl(datatype, dataRange, annotations);
    }

    public OWLDatatypeDefinitionAxiom getOWLDatatypeDefinitionAxiom(OWLDatatype datatype, OWL2Datatype dataRange, Collection<OWLAnnotation> annotations) {
        return this.getOWLDatatypeDefinitionAxiom(datatype, (OWLDataRange)dataRange.getDatatype((DatatypeProvider)this), annotations);
    }

    public OWLLiteral getOWLLiteral(String lexicalValue, OWLDatatype datatype) {
        OWLAPIPreconditions.checkNotNull((Object)lexicalValue, (String)"lexicalValue cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)datatype, (String)"datatype cannot be null");
        return this.dataFactoryInternals.getOWLLiteral(lexicalValue, datatype);
    }

    public OWLLiteral getOWLLiteral(int value) {
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    public OWLLiteral getOWLLiteral(double value) {
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    public OWLLiteral getOWLLiteral(float value) {
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    public OWLLiteral getOWLLiteral(String value) {
        OWLAPIPreconditions.checkNotNull((Object)value, (String)"value cannot be null");
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    public OWLLiteral getOWLLiteral(String literal, @Nullable String lang) {
        OWLAPIPreconditions.checkNotNull((Object)literal, (String)"literal cannot be null");
        return this.dataFactoryInternals.getOWLLiteral(literal, lang);
    }

    public OWLDatatype getBooleanOWLDatatype() {
        return InternalizedEntities.XSDBOOLEAN;
    }

    public OWLDatatype getStringOWLDatatype() {
        return InternalizedEntities.XSDSTRING;
    }

    public OWLDatatype getDoubleOWLDatatype() {
        return InternalizedEntities.XSDDOUBLE;
    }

    public OWLDatatype getFloatOWLDatatype() {
        return InternalizedEntities.XSDFLOAT;
    }

    public OWLDatatype getIntegerOWLDatatype() {
        return InternalizedEntities.XSDINTEGER;
    }

    public OWLDatatype getTopDatatype() {
        return InternalizedEntities.RDFSLITERAL;
    }

    public OWLDatatype getRDFPlainLiteral() {
        return InternalizedEntities.PLAIN;
    }
}

