/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.Static;

final class UnitsMap
extends Static {
    static final Integer I9122;
    static final Map<Unit<?>, Integer> EPSG_CODES;
    private static final Map<Unit<?>, Unit<?>> COMMONS;

    private UnitsMap() {
    }

    static <A extends Quantity> Unit<A> canonicalize(Unit<A> unit) {
        Unit<?> unit2 = COMMONS.get(unit);
        if (unit2 != null) {
            return unit2;
        }
        return unit;
    }

    static {
        int n;
        byte[] byArray;
        I9122 = 9122;
        EPSG_CODES = new HashMap(20);
        for (byte by : byArray = new byte[]{1, 2, 30, 36, 101, 102, 103, 104, 105, 108, 109, 111, 110, -55, -54}) {
            n = 9000 + (by & 0xFF);
            EPSG_CODES.put(Units.valueOfEPSG(n), n);
        }
        COMMONS = new HashMap(48);
        COMMONS.put(Units.MILLISECOND, Units.MILLISECOND);
        boolean bl = false;
        do {
            for (Field field : (bl ? NonSI.class : SI.class).getFields()) {
                Unit unit;
                Object object;
                n = field.getModifiers();
                if (!Modifier.isStatic(n) || !Modifier.isFinal(n)) continue;
                try {
                    object = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Object)illegalAccessException);
                }
                if (!(object instanceof Unit) || !Units.isLinear(unit = (Unit)object) && !Units.isAngular(unit) && !Units.isScale(unit)) continue;
                COMMONS.put(unit, unit);
            }
        } while (bl = !bl);
    }
}

