/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.IdentifierMapAdapter;
import org.apache.sis.internal.jaxb.SpecializedIdentifier;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.ValueConverter;
import org.apache.sis.xml.XLink;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

public final class IdentifierMapWithSpecialCases
extends IdentifierMapAdapter {
    private static final long serialVersionUID = 8135179749011991090L;

    public IdentifierMapWithSpecialCases(Collection<Identifier> collection) {
        super(collection);
    }

    private static int specialCase(Object object) {
        if (object == IdentifierSpace.HREF) {
            return 2;
        }
        return -1;
    }

    private String getHRef() {
        URI uRI;
        XLink xLink = super.getSpecialized(IdentifierSpace.XLINK);
        if (xLink != null && (uRI = xLink.getHRef()) != null) {
            return uRI.toString();
        }
        return null;
    }

    private URI setHRef(URI uRI) {
        URI uRI2 = super.putSpecialized(IdentifierSpace.HREF, null);
        XLink xLink = super.getSpecialized(IdentifierSpace.XLINK);
        if (xLink != null) {
            if (uRI2 == null) {
                uRI2 = xLink.getHRef();
            }
            xLink.setHRef(uRI);
        } else if (uRI != null) {
            xLink = new XLink();
            xLink.setHRef(uRI);
            super.putSpecialized(IdentifierSpace.XLINK, xLink);
        }
        return uRI2;
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object) || Objects.equals(object, this.getHRef());
    }

    @Override
    public boolean containsKey(Object object) {
        if (super.containsKey(object)) {
            return true;
        }
        switch (IdentifierMapWithSpecialCases.specialCase(object)) {
            case 2: {
                XLink xLink = super.getSpecialized(IdentifierSpace.XLINK);
                return xLink != null && xLink.getHRef() != null;
            }
        }
        return false;
    }

    @Override
    public <T> T getSpecialized(IdentifierSpace<T> identifierSpace) {
        Object object = super.getSpecialized(identifierSpace);
        if (object == null) {
            switch (IdentifierMapWithSpecialCases.specialCase(identifierSpace)) {
                case 2: {
                    XLink xLink = super.getSpecialized(IdentifierSpace.XLINK);
                    if (xLink == null) break;
                    object = xLink.getHRef();
                    break;
                }
            }
        }
        return object;
    }

    @Override
    public String get(Object object) {
        String string = super.get(object);
        if (string == null) {
            switch (IdentifierMapWithSpecialCases.specialCase(object)) {
                case 2: {
                    string = this.getHRef();
                }
            }
        }
        return string;
    }

    @Override
    public String put(Citation citation, String string) throws UnsupportedOperationException {
        Class<URI> clazz;
        URI uRI;
        URISyntaxException uRISyntaxException;
        Context context;
        Object object;
        block6: {
            Object object2;
            switch (IdentifierMapWithSpecialCases.specialCase(citation)) {
                default: {
                    return super.put(citation, string);
                }
                case 2: 
            }
            object = null;
            if (string != null) {
                context = Context.current();
                object2 = Context.converter(context);
                try {
                    object = ((ValueConverter)object2).toURI((MarshalContext)context, string);
                }
                catch (URISyntaxException uRISyntaxException2) {
                    uRISyntaxException = uRISyntaxException2;
                    uRI = this.setHRef(null);
                    clazz = URI.class;
                    break block6;
                }
            }
            object2 = this.getUnspecialized(citation);
            return (object = this.setHRef((URI)object)) != null ? ((URI)object).toString() : object2;
        }
        SpecializedIdentifier.parseFailure(context, string, clazz, uRISyntaxException);
        object = super.put(citation, string);
        return object == null && uRI != null ? ((Object)uRI).toString() : object;
    }

    @Override
    public <T> T putSpecialized(IdentifierSpace<T> identifierSpace, T t) throws UnsupportedOperationException {
        switch (IdentifierMapWithSpecialCases.specialCase(identifierSpace)) {
            default: {
                return super.putSpecialized(identifierSpace, t);
            }
            case 2: 
        }
        return (T)this.setHRef((URI)t);
    }
}

