/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.robotstxt;

import edu.uci.ics.crawler4j.crawler.Page;
import edu.uci.ics.crawler4j.fetcher.PageFetchResult;
import edu.uci.ics.crawler4j.fetcher.PageFetcher;
import edu.uci.ics.crawler4j.robotstxt.HostDirectives;
import edu.uci.ics.crawler4j.robotstxt.RobotstxtConfig;
import edu.uci.ics.crawler4j.robotstxt.RobotstxtParser;
import edu.uci.ics.crawler4j.url.WebURL;
import edu.uci.ics.crawler4j.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class RobotstxtServer {
    protected RobotstxtConfig config;
    protected final Map<String, HostDirectives> host2directivesCache = new HashMap<String, HostDirectives>();
    protected PageFetcher pageFetcher;

    public RobotstxtServer(RobotstxtConfig config, PageFetcher pageFetcher) {
        this.config = config;
        this.pageFetcher = pageFetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allows(WebURL webURL) {
        if (!this.config.isEnabled()) {
            return true;
        }
        try {
            URL url = new URL(webURL.getURL());
            String host = url.getHost().toLowerCase();
            String path = url.getPath();
            HostDirectives directives = this.host2directivesCache.get(host);
            if (directives != null && directives.needsRefetch()) {
                Map<String, HostDirectives> map = this.host2directivesCache;
                synchronized (map) {
                    this.host2directivesCache.remove(host);
                    directives = null;
                }
            }
            if (directives == null) {
                directives = this.fetchDirectives(host);
            }
            return directives.allows(path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostDirectives fetchDirectives(String host) {
        WebURL robotsTxtUrl = new WebURL();
        robotsTxtUrl.setURL("http://" + host + "/robots.txt");
        HostDirectives directives = null;
        PageFetchResult fetchResult = null;
        try {
            fetchResult = this.pageFetcher.fetchHeader(robotsTxtUrl);
            if (fetchResult.getStatusCode() == 200) {
                Page page = new Page(robotsTxtUrl);
                fetchResult.fetchContent(page);
                if (Util.hasPlainTextContent(page.getContentType())) {
                    try {
                        String content = page.getContentCharset() == null ? new String(page.getContentData()) : new String(page.getContentData(), page.getContentCharset());
                        directives = RobotstxtParser.parse(content, this.config.getUserAgentName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        finally {
            fetchResult.discardContentIfNotConsumed();
        }
        if (directives == null) {
            directives = new HostDirectives();
        }
        Map<String, HostDirectives> map = this.host2directivesCache;
        synchronized (map) {
            if (this.host2directivesCache.size() == this.config.getCacheSize()) {
                String minHost = null;
                long minAccessTime = Long.MAX_VALUE;
                for (Map.Entry<String, HostDirectives> entry : this.host2directivesCache.entrySet()) {
                    if (entry.getValue().getLastAccessTime() >= minAccessTime) continue;
                    minAccessTime = entry.getValue().getLastAccessTime();
                    minHost = entry.getKey();
                }
                this.host2directivesCache.remove(minHost);
            }
            this.host2directivesCache.put(host, directives);
        }
        return directives;
    }
}

