/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.frontier;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import edu.uci.ics.crawler4j.frontier.WebURLTupleBinding;
import edu.uci.ics.crawler4j.url.WebURL;
import edu.uci.ics.crawler4j.util.Util;
import java.util.ArrayList;
import java.util.List;

public class WorkQueues {
    protected Database urlsDB = null;
    protected Environment env;
    protected boolean resumable;
    protected WebURLTupleBinding webURLBinding;
    protected final Object mutex = new Object();

    public WorkQueues(Environment env, String dbName, boolean resumable) throws DatabaseException {
        this.env = env;
        this.resumable = resumable;
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(resumable);
        dbConfig.setDeferredWrite(!resumable);
        this.urlsDB = env.openDatabase(null, dbName, dbConfig);
        this.webURLBinding = new WebURLTupleBinding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebURL> get(int max) throws DatabaseException {
        Object object = this.mutex;
        synchronized (object) {
            int matches = 0;
            ArrayList<WebURL> results = new ArrayList<WebURL>(max);
            Cursor cursor = null;
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            Transaction txn = this.resumable ? this.env.beginTransaction(null, null) : null;
            try {
                cursor = this.urlsDB.openCursor(txn, null);
                OperationStatus result = cursor.getFirst(key, value, null);
                while (matches < max && result == OperationStatus.SUCCESS) {
                    if (value.getData().length > 0) {
                        results.add((WebURL)this.webURLBinding.entryToObject(value));
                        ++matches;
                    }
                    result = cursor.getNext(key, value, null);
                }
            }
            catch (DatabaseException e) {
                if (txn != null) {
                    txn.abort();
                    txn = null;
                }
                throw e;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                if (txn != null) {
                    txn.commit();
                }
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int count) throws DatabaseException {
        Object object = this.mutex;
        synchronized (object) {
            Cursor cursor = null;
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            Transaction txn = this.resumable ? this.env.beginTransaction(null, null) : null;
            try {
                cursor = this.urlsDB.openCursor(txn, null);
                OperationStatus result = cursor.getFirst(key, value, null);
                for (int matches = 0; matches < count && result == OperationStatus.SUCCESS; ++matches) {
                    cursor.delete();
                    result = cursor.getNext(key, value, null);
                }
            }
            catch (DatabaseException e) {
                if (txn != null) {
                    txn.abort();
                    txn = null;
                }
                throw e;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                if (txn != null) {
                    txn.commit();
                }
            }
        }
    }

    public void put(WebURL url) throws DatabaseException {
        byte[] keyData = new byte[6];
        keyData[0] = url.getPriority();
        keyData[1] = (byte)(url.getDepth() > 127 ? 127 : (byte)url.getDepth());
        Util.putIntInByteArray(url.getDocid(), keyData, 2);
        DatabaseEntry value = new DatabaseEntry();
        this.webURLBinding.objectToEntry(url, value);
        Transaction txn = this.resumable ? this.env.beginTransaction(null, null) : null;
        this.urlsDB.put(txn, new DatabaseEntry(keyData), value);
        if (this.resumable && txn != null) {
            txn.commit();
        }
    }

    public long getLength() {
        try {
            return this.urlsDB.count();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void sync() {
        if (this.resumable) {
            return;
        }
        if (this.urlsDB == null) {
            return;
        }
        try {
            this.urlsDB.sync();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.urlsDB.close();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }
}

