/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.fetcher;

import edu.uci.ics.crawler4j.crawler.Configurable;
import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import edu.uci.ics.crawler4j.fetcher.IdleConnectionMonitorThread;
import edu.uci.ics.crawler4j.fetcher.PageFetchResult;
import edu.uci.ics.crawler4j.url.URLCanonicalizer;
import edu.uci.ics.crawler4j.url.WebURL;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParamBean;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class PageFetcher
extends Configurable {
    protected static final Logger logger = Logger.getLogger(PageFetcher.class);
    protected ThreadSafeClientConnManager connectionManager;
    protected DefaultHttpClient httpClient;
    protected final Object mutex = new Object();
    protected long lastFetchTime = 0L;
    protected IdleConnectionMonitorThread connectionMonitorThread = null;

    public PageFetcher(CrawlConfig config) {
        super(config);
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParamBean paramsBean = new HttpProtocolParamBean((HttpParams)params);
        paramsBean.setVersion(HttpVersion.HTTP_1_1);
        paramsBean.setContentCharset("UTF-8");
        paramsBean.setUseExpectContinue(false);
        params.setParameter("http.useragent", (Object)config.getUserAgentString());
        params.setIntParameter("http.socket.timeout", config.getSocketTimeout());
        params.setIntParameter("http.connection.timeout", config.getConnectionTimeout());
        params.setBooleanParameter("http.protocol.handle-redirects", false);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        if (config.isIncludeHttpsPages()) {
            schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        }
        this.connectionManager = new ThreadSafeClientConnManager(schemeRegistry);
        this.connectionManager.setMaxTotal(config.getMaxTotalConnections());
        this.connectionManager.setDefaultMaxPerRoute(config.getMaxConnectionsPerHost());
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)this.connectionManager, (HttpParams)params);
        if (config.getProxyHost() != null) {
            if (config.getProxyUsername() != null) {
                this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(config.getProxyHost(), config.getProxyPort()), (Credentials)new UsernamePasswordCredentials(config.getProxyUsername(), config.getProxyPassword()));
            }
            HttpHost proxy = new HttpHost(config.getProxyHost(), config.getProxyPort());
            this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        this.httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                HttpEntity entity = response.getEntity();
                Header contentEncoding = entity.getContentEncoding();
                if (contentEncoding != null) {
                    HeaderElement[] codecs;
                    for (HeaderElement codec : codecs = contentEncoding.getElements()) {
                        if (!codec.getName().equalsIgnoreCase("gzip")) continue;
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                }
            }
        });
        if (this.connectionMonitorThread == null) {
            this.connectionMonitorThread = new IdleConnectionMonitorThread(this.connectionManager);
        }
        this.connectionMonitorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageFetchResult fetchHeader(WebURL webUrl) {
        PageFetchResult fetchResult = new PageFetchResult();
        String toFetchURL = webUrl.getURL();
        HttpGet get = null;
        try {
            get = new HttpGet(toFetchURL);
            Object object = this.mutex;
            synchronized (object) {
                long now = new Date().getTime();
                if (now - this.lastFetchTime < (long)this.config.getPolitenessDelay()) {
                    Thread.sleep((long)this.config.getPolitenessDelay() - (now - this.lastFetchTime));
                }
                this.lastFetchTime = new Date().getTime();
            }
            get.addHeader("Accept-Encoding", "gzip");
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            fetchResult.setEntity(response.getEntity());
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                if (statusCode != 404) {
                    if (statusCode == 301 || statusCode == 302) {
                        Object movedToUrl;
                        Header header = response.getFirstHeader("Location");
                        if (header != null) {
                            movedToUrl = header.getValue();
                            movedToUrl = URLCanonicalizer.getCanonicalURL((String)movedToUrl, toFetchURL);
                            fetchResult.setMovedToUrl((String)movedToUrl);
                        }
                        fetchResult.setStatusCode(statusCode);
                        movedToUrl = fetchResult;
                        return movedToUrl;
                    }
                    logger.info((Object)("Failed: " + response.getStatusLine().toString() + ", while fetching " + toFetchURL));
                }
                fetchResult.setStatusCode(response.getStatusLine().getStatusCode());
                PageFetchResult header = fetchResult;
                return header;
            }
            fetchResult.setFetchedUrl(toFetchURL);
            String uri = get.getURI().toString();
            if (!uri.equals(toFetchURL) && !URLCanonicalizer.getCanonicalURL(uri).equals(toFetchURL)) {
                fetchResult.setFetchedUrl(uri);
            }
            if (fetchResult.getEntity() != null) {
                PageFetchResult pageFetchResult;
                long size = fetchResult.getEntity().getContentLength();
                if (size == -1L) {
                    Header length = response.getLastHeader("Content-Length");
                    if (length == null) {
                        length = response.getLastHeader("Content-length");
                    }
                    size = length != null ? (long)Integer.parseInt(length.getValue()) : -1L;
                }
                if (size > (long)this.config.getMaxDownloadSize()) {
                    fetchResult.setStatusCode(1001);
                    pageFetchResult = fetchResult;
                    return pageFetchResult;
                }
                fetchResult.setStatusCode(200);
                pageFetchResult = fetchResult;
                return pageFetchResult;
            }
            get.abort();
        }
        catch (IOException e) {
            logger.error((Object)("Fatal transport error: " + e.getMessage() + " while fetching " + toFetchURL + " (link found in doc #" + webUrl.getParentDocid() + ")"));
            fetchResult.setStatusCode(1005);
            PageFetchResult pageFetchResult = fetchResult;
            return pageFetchResult;
        }
        catch (IllegalStateException e) {
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                logger.error((Object)("Error while fetching " + webUrl.getURL()));
            } else {
                logger.error((Object)(e.getMessage() + " while fetching " + webUrl.getURL()));
            }
        }
        finally {
            try {
                if (fetchResult.getEntity() == null && get != null) {
                    get.abort();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        fetchResult.setStatusCode(1006);
        return fetchResult;
    }

    public synchronized void shutDown() {
        if (this.connectionMonitorThread != null) {
            this.connectionManager.shutdown();
            this.connectionMonitorThread.shutdown();
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    private static class GzipDecompressingEntity
    extends HttpEntityWrapper {
        public GzipDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            InputStream wrappedin = this.wrappedEntity.getContent();
            return new GZIPInputStream(wrappedin);
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

