/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.crawler;

import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import edu.uci.ics.crawler4j.crawler.Configurable;
import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import edu.uci.ics.crawler4j.crawler.WebCrawler;
import edu.uci.ics.crawler4j.fetcher.PageFetcher;
import edu.uci.ics.crawler4j.frontier.DocIDServer;
import edu.uci.ics.crawler4j.frontier.Frontier;
import edu.uci.ics.crawler4j.robotstxt.RobotstxtServer;
import edu.uci.ics.crawler4j.url.URLCanonicalizer;
import edu.uci.ics.crawler4j.url.WebURL;
import edu.uci.ics.crawler4j.util.IO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CrawlController
extends Configurable {
    private static final Logger logger = Logger.getLogger((String)CrawlController.class.getName());
    protected Object customData;
    protected List<Object> crawlersLocalData = new ArrayList<Object>();
    protected boolean finished;
    protected boolean shuttingDown;
    protected PageFetcher pageFetcher;
    protected RobotstxtServer robotstxtServer;
    protected Frontier frontier;
    protected DocIDServer docIdServer;
    protected final Object waitingLock = new Object();

    public CrawlController(CrawlConfig config, PageFetcher pageFetcher, RobotstxtServer robotstxtServer) throws Exception {
        super(config);
        config.validate();
        File folder = new File(config.getCrawlStorageFolder());
        if (!folder.exists() && !folder.mkdirs()) {
            throw new Exception("Couldn't create this folder: " + folder.getAbsolutePath());
        }
        boolean resumable = config.isResumableCrawling();
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(resumable);
        envConfig.setLocking(resumable);
        File envHome = new File(config.getCrawlStorageFolder() + "/frontier");
        if (!envHome.exists() && !envHome.mkdir()) {
            throw new Exception("Couldn't create this folder: " + envHome.getAbsolutePath());
        }
        if (!resumable) {
            IO.deleteFolderContents(envHome);
        }
        Environment env = new Environment(envHome, envConfig);
        this.docIdServer = new DocIDServer(env, config);
        this.frontier = new Frontier(env, config, this.docIdServer);
        this.pageFetcher = pageFetcher;
        this.robotstxtServer = robotstxtServer;
        this.finished = false;
        this.shuttingDown = false;
    }

    public <T extends WebCrawler> void start(Class<T> _c, int numberOfCrawlers) {
        this.start(_c, numberOfCrawlers, true);
    }

    public <T extends WebCrawler> void startNonBlocking(Class<T> _c, int numberOfCrawlers) {
        this.start(_c, numberOfCrawlers, false);
    }

    protected <T extends WebCrawler> void start(final Class<T> _c, int numberOfCrawlers, boolean isBlocking) {
        try {
            this.finished = false;
            this.crawlersLocalData.clear();
            final ArrayList<Thread> threads = new ArrayList<Thread>();
            final ArrayList<WebCrawler> crawlers = new ArrayList<WebCrawler>();
            for (int i = 1; i <= numberOfCrawlers; ++i) {
                WebCrawler crawler = (WebCrawler)_c.newInstance();
                Thread thread = new Thread((Runnable)crawler, "Crawler " + i);
                crawler.setThread(thread);
                crawler.init(i, this);
                thread.start();
                crawlers.add(crawler);
                threads.add(thread);
                logger.info((Object)("Crawler " + i + " started."));
            }
            final CrawlController controller = this;
            Thread monitorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object object = CrawlController.this.waitingLock;
                        synchronized (object) {
                            while (true) {
                                Thread thread;
                                int i;
                                CrawlController.this.sleep(10);
                                boolean someoneIsWorking = false;
                                for (i = 0; i < threads.size(); ++i) {
                                    thread = (Thread)threads.get(i);
                                    if (!thread.isAlive()) {
                                        if (CrawlController.this.shuttingDown) continue;
                                        logger.info((Object)("Thread " + i + " was dead, I'll recreate it."));
                                        WebCrawler crawler = (WebCrawler)_c.newInstance();
                                        thread = new Thread((Runnable)crawler, "Crawler " + (i + 1));
                                        threads.remove(i);
                                        threads.add(i, thread);
                                        crawler.setThread(thread);
                                        crawler.init(i + 1, controller);
                                        thread.start();
                                        crawlers.remove(i);
                                        crawlers.add(i, crawler);
                                        continue;
                                    }
                                    if (!((WebCrawler)crawlers.get(i)).isNotWaitingForNewURLs()) continue;
                                    someoneIsWorking = true;
                                }
                                if (someoneIsWorking) continue;
                                logger.info((Object)"It looks like no thread is working, waiting for 10 seconds to make sure...");
                                CrawlController.this.sleep(10);
                                someoneIsWorking = false;
                                for (i = 0; i < threads.size(); ++i) {
                                    thread = (Thread)threads.get(i);
                                    if (!thread.isAlive() || !((WebCrawler)crawlers.get(i)).isNotWaitingForNewURLs()) continue;
                                    someoneIsWorking = true;
                                }
                                if (someoneIsWorking) continue;
                                if (CrawlController.this.shuttingDown) break;
                                long queueLength = CrawlController.this.frontier.getQueueLength();
                                if (queueLength > 0L) continue;
                                logger.info((Object)"No thread is working and no more URLs are in queue waiting for another 10 seconds to make sure...");
                                CrawlController.this.sleep(10);
                                queueLength = CrawlController.this.frontier.getQueueLength();
                                if (queueLength <= 0L) break;
                            }
                            logger.info((Object)"All of the crawlers are stopped. Finishing the process...");
                            CrawlController.this.frontier.finish();
                            for (WebCrawler crawler : crawlers) {
                                crawler.onBeforeExit();
                                CrawlController.this.crawlersLocalData.add(crawler.getMyLocalData());
                            }
                            logger.info((Object)"Waiting for 10 seconds before final clean up...");
                            CrawlController.this.sleep(10);
                            CrawlController.this.frontier.close();
                            CrawlController.this.docIdServer.close();
                            CrawlController.this.pageFetcher.shutDown();
                            CrawlController.this.finished = true;
                            CrawlController.this.waitingLock.notifyAll();
                            return;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
            });
            monitorThread.start();
            if (isBlocking) {
                this.waitUntilFinish();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinish() {
        while (!this.finished) {
            Object object = this.waitingLock;
            synchronized (object) {
                if (this.finished) {
                    return;
                }
                try {
                    this.waitingLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public List<Object> getCrawlersLocalData() {
        return this.crawlersLocalData;
    }

    protected void sleep(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addSeed(String pageUrl) {
        this.addSeed(pageUrl, -1);
    }

    public void addSeed(String pageUrl, int docId) {
        String canonicalUrl = URLCanonicalizer.getCanonicalURL(pageUrl);
        if (canonicalUrl == null) {
            logger.error((Object)("Invalid seed URL: " + pageUrl));
            return;
        }
        if (docId < 0) {
            docId = this.docIdServer.getDocId(canonicalUrl);
            if (docId > 0) {
                return;
            }
            docId = this.docIdServer.getNewDocID(canonicalUrl);
        } else {
            try {
                this.docIdServer.addUrlAndDocId(canonicalUrl, docId);
            }
            catch (Exception e) {
                logger.error((Object)("Could not add seed: " + e.getMessage()));
            }
        }
        WebURL webUrl = new WebURL();
        webUrl.setURL(canonicalUrl);
        webUrl.setDocid(docId);
        webUrl.setDepth((short)0);
        if (!this.robotstxtServer.allows(webUrl)) {
            logger.info((Object)("Robots.txt does not allow this seed: " + pageUrl));
        } else {
            this.frontier.schedule(webUrl);
        }
    }

    public void addSeenUrl(String url, int docId) {
        String canonicalUrl = URLCanonicalizer.getCanonicalURL(url);
        if (canonicalUrl == null) {
            logger.error((Object)("Invalid Url: " + url));
            return;
        }
        try {
            this.docIdServer.addUrlAndDocId(canonicalUrl, docId);
        }
        catch (Exception e) {
            logger.error((Object)("Could not add seen url: " + e.getMessage()));
        }
    }

    public PageFetcher getPageFetcher() {
        return this.pageFetcher;
    }

    public void setPageFetcher(PageFetcher pageFetcher) {
        this.pageFetcher = pageFetcher;
    }

    public RobotstxtServer getRobotstxtServer() {
        return this.robotstxtServer;
    }

    public void setRobotstxtServer(RobotstxtServer robotstxtServer) {
        this.robotstxtServer = robotstxtServer;
    }

    public Frontier getFrontier() {
        return this.frontier;
    }

    public void setFrontier(Frontier frontier) {
        this.frontier = frontier;
    }

    public DocIDServer getDocIdServer() {
        return this.docIdServer;
    }

    public void setDocIdServer(DocIDServer docIdServer) {
        this.docIdServer = docIdServer;
    }

    public Object getCustomData() {
        return this.customData;
    }

    public void setCustomData(Object customData) {
        this.customData = customData;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public void Shutdown() {
        logger.info((Object)"Shutting down...");
        this.shuttingDown = true;
        this.frontier.finish();
    }
}

