/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.any23.extractor.html;

import org.apache.any23.validator.ValidationReport;
import org.w3c.dom.Document;

/**
 * Represents the validationReportBuilder generated by a
 * the {@link TagSoupParser} when a document
 * is retrieved and validated.
 *
 * @author Michele Mostarda (mostarda@fbk.eu)
 * @author Davide Palmisano (palmisano@fbk.eu)
 */
public class DocumentReport {

    private ValidationReport validationReport;
    private Document document;

    public DocumentReport(ValidationReport validationReport, Document document) {
        this.validationReport = validationReport;
        this.document = document;
    }

    public ValidationReport getReport() {
        return validationReport;
    }

    public Document getDocument() {
        return document;
    }

}
