# AMQP

Apache ActiveMQ Artemis supports the [AMQP
1.0](https://www.oasis-open.org/committees/tc_home.php?wg_abbrev=amqp)
specification. By default there are `acceptor` elements configured to accept
AMQP connections on ports `61616` and `5672`.

See the general [Protocols and Interoperability](protocols-interoperability.md)
chapter for details on configuring an `acceptor` for AMQP.

You can use *any* AMQP 1.0 compatible clients.

A short list includes:

- [qpid clients](https://qpid.apache.org/download.html)
- [.NET Clients](https://blogs.apache.org/activemq/entry/using-net-libraries-with-activemq)
- [Javascript NodeJS](https://github.com/noodlefrenzy/node-amqp10)
- [Java Script RHEA](https://github.com/grs/rhea)
- ... and many others.

## Examples

We have a few examples as part of the Artemis distribution:

- .NET: 
  - ./examples/protocols/amqp/dotnet
- ProtonCPP
  - ./examples/protocols/amqp/proton-cpp
  - ./examples/protocols/amqp/proton-clustered-cpp
- Ruby
  - ./examples/protocols/amqp/proton-ruby
- Java (Using the qpid JMS Client)
  - ./examples/protocols/amqp/queue
- Interceptors
  - ./examples/features/standard/interceptor-amqp
  - ./examples/features/standard/broker-plugin

## Message Conversions

The broker will not perform any message conversion to any other protocols when
sending AMQP and receiving AMQP.

However if you intend your message to be received by an AMQP JMS Client, you
must follow the [JMS Mapping
Conventions](https://www.oasis-open.org/committees/download.php/53086/amqp-bindmap-jms-v1.0-wd05.pdf).
If you send a body type that is not recognized by this specification the
conversion between AMQP and any other protocol will make it a Binary Message.
Make sure you follow these conventions if you intend to cross protocols or
languages.  Especially on the message body.

A compatibility setting allows aligning the naming convention of AMQP queues
(JMS Durable and Shared Subscriptions) with CORE. For backwards compatibility
reasons, you need to explicitly enable this via broker configuration:

- `amqp-use-core-subscription-naming`
   - `true` - use queue naming convention that is aligned with CORE.
   - `false` (default) - use older naming convention.   

## Intercepting and changing messages
 
We don't recommend changing messages at the server's side for a few reasons:
 
- AMQP messages are meant to be immutable
- The message won't be the original message the user sent
- AMQP has the possibility of signing messages. The signature would be broken.
- For performance reasons. We try not to re-encode (or even decode) messages.

If regardless these recommendations you still need and want to intercept and
change AMQP messages, look at the aforementioned interceptor examples.

## AMQP and security

The Apache ActiveMQ Artemis Server accepts the PLAIN, ANONYMOUS, and GSSAPI
SASL mechanism. These are implemented on the broker's [security](security.md)
infrastructure.

## AMQP and destinations

If an AMQP Link is dynamic then a temporary queue will be created and either
the remote source or remote target address will be set to the name of the
temporary queue. If the Link is not dynamic then the the address of the remote
target or source will used for the queue. If this does not exist then it will
be auto-created if the settings allow.

## AMQP and Multicast Addresses (Topics)

Although AMQP has no notion of "topics" it is still possible to treat AMQP
consumers or receivers as subscriptions rather than just consumers on a queue.
By default any receiving link that attaches to an address that has only
`multicast` enabled will be treated as a subscription and a corresponding
subscription queue will be created. If the Terminus Durability is either
`UNSETTLED_STATE` or `CONFIGURATION` then the queue will be made durable
(similar to a JMS durable subscription) and given a name made up from the
container id and the link name, something like `my-container-id:my-link-name`.
If the Terminus Durability is configured as `NONE` then a volatile `multicast`
queue will be created.

## AMQP and Coordinations - Handling Transactions

An AMQP links target can also be a Coordinator. A Coordinator is used to handle
transactions. If a coordinator is used then the underlying server session will
be transacted and will be either rolled back or committed via the coordinator.

> **Note:**
>
> AMQP allows the use of multiple transactions per session,
> `amqp:multi-txns-per-ssn`, however in this version of Apache ActiveMQ Artemis
> will only support single transactions per session.

## AMQP scheduling message delivery

An AMQP message can provide scheduling information that controls the time in
the future when the message will be delivered at the earliest.  This
information is provided by adding a message annotation to the sent message.

There are two different message annotations that can be used to schedule a
message for later delivery:

- `x-opt-delivery-time`
  The specified value must be a positive long corresponding to the time the
  message should be made available for delivery (in milliseconds).

- `x-opt-delivery-delay`
  The specified value must be a positive long corresponding to the amount of
  milliseconds after the broker receives the given message before it should be
  made available for delivery.

If both annotations are present in the same message then the broker will prefer
the more specific `x-opt-delivery-time` value.
