/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="4.9.0", label="dataformat,transformation", title="Fury")
@XmlRootElement(name="fury")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FuryDataFormat
extends DataFormatDefinition {
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute(name="unmarshalType")
    @Metadata(description="Class of the java type to use when unmarshalling")
    private String unmarshalTypeName;
    @XmlAttribute
    @Metadata(label="advanced", description="Whether to require register classes", defaultValue="true", javaType="java.lang.Boolean")
    private String requireClassRegistration;
    @XmlAttribute
    @Metadata(label="advanced", description="Whether to use the threadsafe fury", defaultValue="true", javaType="java.lang.Boolean")
    private String threadSafe;
    @XmlAttribute
    @Metadata(label="advanced", description="Whether to auto-discover Fury from the registry", defaultValue="true", javaType="java.lang.Boolean")
    private String allowAutoWiredFury;

    public FuryDataFormat() {
        super("fury");
    }

    public FuryDataFormat(FuryDataFormat source) {
        super(source);
        this.unmarshalType = source.unmarshalType;
        this.unmarshalTypeName = source.unmarshalTypeName;
        this.requireClassRegistration = source.requireClassRegistration;
        this.threadSafe = source.threadSafe;
        this.allowAutoWiredFury = source.allowAutoWiredFury;
    }

    private FuryDataFormat(Builder builder) {
        this.unmarshalType = builder.unmarshalType;
        this.unmarshalTypeName = builder.unmarshalTypeName;
        this.requireClassRegistration = builder.requireClassRegistration;
        this.threadSafe = builder.threadSafe;
        this.allowAutoWiredFury = builder.allowAutoWiredFury;
    }

    @Override
    public FuryDataFormat copyDefinition() {
        return new FuryDataFormat(this);
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public String getRequireClassRegistration() {
        return this.requireClassRegistration;
    }

    public void setRequireClassRegistration(String requireClassRegistration) {
        this.requireClassRegistration = requireClassRegistration;
    }

    public String getThreadSafe() {
        return this.threadSafe;
    }

    public void setThreadSafe(String threadSafe) {
        this.threadSafe = threadSafe;
    }

    public String getAllowAutoWiredFury() {
        return this.allowAutoWiredFury;
    }

    public void setAllowAutoWiredFury(String allowAutoWiredFury) {
        this.allowAutoWiredFury = allowAutoWiredFury;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<FuryDataFormat> {
        private Class<?> unmarshalType;
        private String unmarshalTypeName;
        private String requireClassRegistration;
        private String threadSafe;
        private String allowAutoWiredFury;

        public Builder unmarshalType(Class<?> value) {
            this.unmarshalType = value;
            return this;
        }

        public Builder unmarshalTypeName(String value) {
            this.unmarshalTypeName = value;
            return this;
        }

        public Builder requireClassRegistration(String value) {
            this.requireClassRegistration = value;
            return this;
        }

        public Builder threadSafe(String value) {
            this.threadSafe = value;
            return this;
        }

        public Builder allowAutoWiredFury(String value) {
            this.allowAutoWiredFury = value;
            return this;
        }

        @Override
        public FuryDataFormat end() {
            return new FuryDataFormat(this);
        }
    }
}

