/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.errorhandler;

import org.apache.camel.Predicate;

public final class ExceptionPolicyKey {
    private final String routeId;
    private final Class<? extends Throwable> exceptionClass;
    private final Predicate when;

    public ExceptionPolicyKey(String routeId, Class<? extends Throwable> exceptionClass, Predicate when) {
        this.routeId = routeId;
        this.exceptionClass = exceptionClass;
        this.when = when;
    }

    public Class<?> getExceptionClass() {
        return this.exceptionClass;
    }

    public Predicate getWhen() {
        return this.when;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionPolicyKey that = (ExceptionPolicyKey)o;
        if (this.exceptionClass != null ? !this.exceptionClass.equals(that.exceptionClass) : that.exceptionClass != null) {
            return false;
        }
        if (this.routeId != null ? !this.routeId.equals(that.routeId) : that.routeId != null) {
            return false;
        }
        return !(this.when != null ? !this.when.equals(that.when) : that.when != null);
    }

    public int hashCode() {
        int result = this.routeId != null ? this.routeId.hashCode() : 0;
        result = 31 * result + (this.exceptionClass != null ? this.exceptionClass.hashCode() : 0);
        result = 31 * result + (this.when != null ? this.when.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ExceptionPolicyKey[route: " + (this.routeId != null ? this.routeId : "<global>") + ", " + String.valueOf(this.exceptionClass) + (String)(this.when != null ? " " + String.valueOf(this.when) : "") + "]";
    }
}

