/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.processor.ProcessorHelper;
import org.apache.camel.spi.ConsumerCache;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.BridgeExceptionHandlerToErrorHandler;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventDrivenPollingConsumer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.cache.DefaultConsumerCache;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollEnricher
extends AsyncProcessorSupport
implements IdAware,
RouteIdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(PollEnricher.class);
    private CamelContext camelContext;
    private ConsumerCache consumerCache;
    private HeadersMapFactory headersMapFactory;
    private volatile String scheme;
    private String id;
    private String routeId;
    private String variableReceive;
    private AggregationStrategy aggregationStrategy;
    private final Expression expression;
    private final String uri;
    private long timeout;
    private boolean aggregateOnException;
    private int cacheSize;
    private boolean ignoreInvalidEndpoint;
    private boolean autoStartupComponents = true;

    public PollEnricher(Expression expression, String uri, long timeout) {
        this.expression = expression;
        this.uri = uri;
        this.timeout = timeout;
    }

    public PollEnricher(String uri, long timeout) {
        this.expression = null;
        this.uri = uri;
        this.timeout = timeout;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getUri() {
        return this.uri;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.consumerCache.getEndpointUtilizationStatistics();
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getVariableReceive() {
        return this.variableReceive;
    }

    public void setVariableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isAggregateOnException() {
        return this.aggregateOnException;
    }

    public void setAggregateOnException(boolean aggregateOnException) {
        this.aggregateOnException = aggregateOnException;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    public boolean isAutoStartupComponents() {
        return this.autoStartupComponents;
    }

    public void setAutoStartupComponents(boolean autoStartupComponents) {
        this.autoStartupComponents = autoStartupComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exchange resourceExchange;
        PollingConsumer consumer;
        Endpoint endpoint;
        try {
            this.preCheckPoll(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)new CamelExchangeException("Error during pre poll check", exchange, (Throwable)e));
            callback.done(true);
            return true;
        }
        Object recipient = null;
        boolean prototype = this.cacheSize < 0;
        try {
            recipient = this.expression != null ? this.expression.evaluate(exchange, Object.class) : this.uri;
            recipient = PollEnricher.prepareRecipient(exchange, recipient);
            Endpoint existing = PollEnricher.getExistingEndpoint(this.camelContext, recipient);
            if (existing == null) {
                endpoint = PollEnricher.resolveEndpoint(this.camelContext, recipient, prototype);
            } else {
                endpoint = existing;
                prototype = false;
            }
            consumer = this.consumerCache.acquirePollingConsumer(endpoint);
        }
        catch (Exception e) {
            if (this.isIgnoreInvalidEndpoint()) {
                LOG.debug("Endpoint uri is invalid: {}. This exception will be ignored.", recipient, (Object)e);
            } else {
                exchange.setException((Throwable)e);
            }
            callback.done(true);
            return true;
        }
        boolean bridgeErrorHandler = PollEnricher.isBridgeErrorHandler(consumer);
        try {
            if (this.timeout < 0L) {
                LOG.debug("Consumer receive: {}", (Object)consumer);
                resourceExchange = consumer.receive();
            } else if (this.timeout == 0L) {
                LOG.debug("Consumer receiveNoWait: {}", (Object)consumer);
                resourceExchange = consumer.receiveNoWait();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Consumer receive with timeout: {} ms. {}", (Object)this.timeout, (Object)consumer);
                }
                resourceExchange = consumer.receive(this.timeout);
            }
            if (resourceExchange == null) {
                LOG.debug("Consumer received no exchange");
            } else {
                LOG.debug("Consumer received: {}", (Object)resourceExchange);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)new CamelExchangeException("Error during poll", exchange, (Throwable)e));
            callback.done(true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.consumerCache.releasePollingConsumer(endpoint, consumer);
            if (prototype) {
                ServiceHelper.stopAndShutdownService((Object)endpoint);
            }
        }
        Object redeliveried = exchange.getIn().getHeader("CamelRedelivered");
        Object redeliveryCounter = exchange.getIn().getHeader("CamelRedeliveryCounter");
        Object redeliveryMaxCounter = exchange.getIn().getHeader("CamelRedeliveryMaxCounter");
        Exception cause = null;
        if (resourceExchange != null && bridgeErrorHandler) {
            cause = resourceExchange.getException();
        }
        Object originalBody = null;
        Map originalHeaders = null;
        if (this.variableReceive != null) {
            try {
                originalBody = exchange.getMessage().getBody();
                originalHeaders = this.headersMapFactory.newMap(exchange.getMessage().getHeaders());
            }
            catch (Exception throwable) {
                exchange.setException((Throwable)throwable);
                callback.done(true);
                return true;
            }
        }
        try {
            if (!this.isAggregateOnException() && resourceExchange != null && resourceExchange.isFailed()) {
                ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)resourceExchange);
            } else {
                PollEnricher.prepareResult(exchange);
                ExchangeHelper.prepareAggregation((Exchange)exchange, (Exchange)resourceExchange);
                Exchange aggregatedExchange = this.aggregationStrategy.aggregate(exchange, resourceExchange);
                if (aggregatedExchange != null) {
                    if (ExchangeHelper.shouldSetVariableResult((Exchange)aggregatedExchange, (String)this.variableReceive)) {
                        ExchangeHelper.setVariableFromMessageBodyAndHeaders((Exchange)aggregatedExchange, (String)this.variableReceive, (Message)aggregatedExchange.getMessage());
                        aggregatedExchange.getMessage().setBody(originalBody);
                        aggregatedExchange.getMessage().setHeaders(originalHeaders);
                    }
                    ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)aggregatedExchange);
                    if (resourceExchange != null) {
                        resourceExchange.getExchangeExtension().handoverCompletions(exchange);
                    }
                }
            }
            if (cause != null) {
                exchange.setException((Throwable)cause);
                exchange.getExchangeExtension().setRedeliveryExhausted(false);
                if (redeliveried != null) {
                    exchange.getMessage().setHeader("CamelRedelivered", redeliveried);
                }
                if (redeliveryCounter != null) {
                    exchange.getMessage().setHeader("CamelRedeliveryCounter", redeliveryCounter);
                }
                if (redeliveryMaxCounter != null) {
                    exchange.getMessage().setHeader("CamelRedeliveryMaxCounter", redeliveryMaxCounter);
                }
            }
            exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)consumer.getEndpoint().getEndpointUri());
        }
        catch (Exception e) {
            exchange.setException((Throwable)new CamelExchangeException("Error occurred during aggregation", exchange, (Throwable)e));
            callback.done(true);
            return true;
        }
        callback.done(true);
        return true;
    }

    private static boolean isBridgeErrorHandler(PollingConsumer consumer) {
        DefaultConsumer defaultConsumer;
        ExceptionHandler handler;
        PollingConsumer delegate = consumer;
        if (consumer instanceof EventDrivenPollingConsumer) {
            EventDrivenPollingConsumer eventDrivenPollingConsumer = (EventDrivenPollingConsumer)consumer;
            delegate = eventDrivenPollingConsumer.getDelegateConsumer();
        }
        boolean bridgeErrorHandler = false;
        if (delegate instanceof DefaultConsumer && (handler = (defaultConsumer = (DefaultConsumer)delegate).getExceptionHandler()) instanceof BridgeExceptionHandlerToErrorHandler) {
            bridgeErrorHandler = true;
        }
        return bridgeErrorHandler;
    }

    protected static Object prepareRecipient(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        return ProcessorHelper.prepareRecipient(exchange, recipient);
    }

    protected static Endpoint getExistingEndpoint(CamelContext context, Object recipient) {
        return ProcessorHelper.getExistingEndpoint(context, recipient);
    }

    protected static Endpoint resolveEndpoint(CamelContext camelContext, Object recipient, boolean prototype) {
        return prototype ? ExchangeHelper.resolvePrototypeEndpoint((CamelContext)camelContext, (Object)recipient) : ExchangeHelper.resolveEndpoint((CamelContext)camelContext, (Object)recipient);
    }

    protected void preCheckPoll(Exchange exchange) throws Exception {
    }

    private static void prepareResult(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
        }
    }

    public String toString() {
        return this.id;
    }

    protected void doBuild() throws Exception {
        if (this.consumerCache == null) {
            this.consumerCache = new DefaultConsumerCache((Object)this, this.camelContext, this.cacheSize);
            LOG.debug("PollEnrich {} using ConsumerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
        }
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = new CopyAggregationStrategy();
        }
        CamelContextAware.trySetCamelContext((Object)this.aggregationStrategy, (CamelContext)this.camelContext);
        ServiceHelper.buildService((Object[])new Object[]{this.consumerCache, this.aggregationStrategy});
    }

    protected void doInit() throws Exception {
        if (this.expression != null) {
            this.expression.init(this.camelContext);
        }
        if (this.isAutoStartupComponents() && this.uri != null) {
            String u = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)this.camelContext, (String)this.uri);
            this.scheme = ExchangeHelper.resolveScheme((String)u);
        }
        this.headersMapFactory = this.camelContext.getCamelContextExtension().getHeadersMapFactory();
        ServiceHelper.initService((Object[])new Object[]{this.consumerCache, this.aggregationStrategy});
    }

    protected void doStart() throws Exception {
        if (this.autoStartupComponents && this.scheme != null) {
            this.camelContext.getComponent(this.scheme);
        }
        ServiceHelper.startService((Object[])new Object[]{this.consumerCache, this.aggregationStrategy});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.aggregationStrategy, this.consumerCache});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.aggregationStrategy, this.consumerCache});
    }

    private static class CopyAggregationStrategy
    implements AggregationStrategy {
        private CopyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange != null) {
                ExchangeHelper.copyResultsPreservePattern((Exchange)oldExchange, (Exchange)newExchange);
            } else {
                oldExchange.getIn().setBody(null);
                oldExchange.setOut(null);
            }
            return oldExchange;
        }
    }
}

