/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jolokia.server.core.util.ClassUtil;

public final class LocalServiceFactory {
    private LocalServiceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> createServices(ClassLoader pClassLoader, String ... pDescriptorPaths) {
        try {
            ServiceEntry.initDefaultOrder();
            HashMap extractorMap = new HashMap();
            for (String descriptor : pDescriptorPaths) {
                LocalServiceFactory.readServiceDefinitions(pClassLoader, extractorMap, descriptor);
            }
            ArrayList ret = new ArrayList();
            ArrayList entries = new ArrayList(extractorMap.keySet());
            Collections.sort(entries);
            for (ServiceEntry entry : entries) {
                ret.add(extractorMap.get(entry));
            }
            ArrayList arrayList = ret;
            return arrayList;
        }
        finally {
            ServiceEntry.removeDefaultOrder();
        }
    }

    public static <T> List<T> createServices(String ... pDescriptorPaths) {
        return LocalServiceFactory.createServices(LocalServiceFactory.class.getClassLoader(), pDescriptorPaths);
    }

    private static <T> void readServiceDefinitions(ClassLoader pClassLoader, Map<ServiceEntry, T> pExtractorMap, String pDefPath) {
        try {
            for (String url : ClassUtil.getResources(pDefPath)) {
                LocalServiceFactory.readServiceDefinitionFromUrl(pClassLoader, pExtractorMap, url);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load extractor from " + pDefPath + ": " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> void readServiceDefinitionFromUrl(ClassLoader pClassLoader, Map<ServiceEntry, T> pExtractorMap, String pUrl) {
        String line = null;
        Exception error = null;
        LineNumberReader reader = null;
        try {
            reader = new LineNumberReader(new InputStreamReader(new URL(pUrl).openStream(), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty() || line.matches("^\\s*#.*$")) continue;
                LocalServiceFactory.createOrRemoveService(pClassLoader, pExtractorMap, line);
            }
            LocalServiceFactory.closeReader(reader);
            if (error == null) return;
        }
        catch (Exception e) {
            error = e;
        }
        finally {
            LocalServiceFactory.closeReader(reader);
            if (error == null) return;
            throw new IllegalStateException("Cannot load service " + line + " defined in " + pUrl + " : " + error + ". Aborting", error);
        }
        throw new IllegalStateException("Cannot load service " + line + " defined in " + pUrl + " : " + error + ". Aborting", error);
    }

    private static <T> void createOrRemoveService(ClassLoader pClassLoader, Map<ServiceEntry, T> pExtractorMap, String pLine) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        block8: {
            if (pLine.isEmpty()) break block8;
            ServiceEntry entry = new ServiceEntry(pLine);
            if (entry.isRemove()) {
                HashSet<ServiceEntry> toRemove = new HashSet<ServiceEntry>();
                for (ServiceEntry key : pExtractorMap.keySet()) {
                    if (!key.getClassName().equals(entry.getClassName())) continue;
                    toRemove.add(key);
                }
                for (ServiceEntry key : toRemove) {
                    pExtractorMap.remove(key);
                }
            } else {
                Class clazz = ClassUtil.classForName(entry.getClassName(), pClassLoader);
                if (clazz == null) {
                    throw new ClassNotFoundException("Class " + entry.getClassName() + " could not be found");
                }
                try {
                    Constructor ctr = clazz.getConstructor(Integer.TYPE);
                    pExtractorMap.put(entry, ctr.newInstance(entry.getOrder()));
                }
                catch (NoSuchMethodException e) {
                    Object ext = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    pExtractorMap.put(entry, ext);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException("Can not instantiate " + entry.getClassName() + ": " + e, e);
                }
            }
        }
    }

    private static void closeReader(LineNumberReader pReader) {
        if (pReader != null) {
            try {
                pReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class ServiceEntry
    implements Comparable<ServiceEntry> {
        private final String className;
        private final boolean remove;
        private int order;
        private static final ThreadLocal<Integer> defaultOrderHolder = new ThreadLocal();
        private static final ThreadLocal<Stack<Integer>> defaultOrders = new ThreadLocal();

        public ServiceEntry(String pLine) {
            String[] parts = pLine.split(",");
            if (parts[0].startsWith("!")) {
                this.remove = true;
                this.className = parts[0].substring(1);
            } else {
                this.remove = false;
                this.className = parts[0];
            }
            if (parts.length > 1) {
                try {
                    this.order = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException exp) {
                    this.order = this.nextDefaultOrder();
                }
            } else {
                this.order = this.nextDefaultOrder();
            }
        }

        int getOrder() {
            return this.order;
        }

        private Integer nextDefaultOrder() {
            Integer defaultOrder = defaultOrderHolder.get();
            defaultOrderHolder.set(defaultOrder + 1);
            return defaultOrder;
        }

        private static void initDefaultOrder() {
            Integer old = defaultOrderHolder.get();
            Stack<Integer> orderStack = defaultOrders.get();
            if (orderStack == null) {
                orderStack = new Stack();
                defaultOrders.set(orderStack);
            }
            if (old != null) {
                orderStack.push(old);
            }
            defaultOrderHolder.set(100);
        }

        private static void removeDefaultOrder() {
            Stack<Integer> orderStack = defaultOrders.get();
            if (orderStack == null) {
                throw new IllegalStateException("No initDefaultOrder() called before");
            }
            if (!orderStack.isEmpty()) {
                defaultOrderHolder.set(orderStack.pop());
            } else {
                defaultOrderHolder.remove();
                defaultOrders.remove();
            }
        }

        private String getClassName() {
            return this.className;
        }

        private boolean isRemove() {
            return this.remove;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceEntry that = (ServiceEntry)o;
            return this.className.equals(that.className);
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        @Override
        public int compareTo(ServiceEntry o) {
            int ret = this.order - o.order;
            return ret != 0 ? ret : this.className.compareTo(o.className);
        }
    }
}

