/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.slf4j.Logger;

public final class PipelineHelper {
    private PipelineHelper() {
    }

    public static boolean continueProcessing(Exchange exchange, String message, Logger log) {
        boolean stop;
        boolean bl = stop = exchange.isFailed() || exchange.isRollbackOnly() || exchange.isRollbackOnlyLast() || exchange.getExchangeExtension().isErrorHandlerHandledSet() && exchange.getExchangeExtension().isErrorHandlerHandled();
        if (stop) {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Message exchange has failed: ").append(message).append(" for exchange: ").append(exchange);
                if (exchange.isRollbackOnly() || exchange.isRollbackOnlyLast()) {
                    sb.append(" Marked as rollback only.");
                }
                if (exchange.getException() != null) {
                    sb.append(" Exception: ").append(exchange.getException());
                }
                if (exchange.getExchangeExtension().isErrorHandlerHandledSet() && exchange.getExchangeExtension().isErrorHandlerHandled()) {
                    sb.append(" Handled by the error handler.");
                }
                log.debug(sb.toString());
            }
            return false;
        }
        if (exchange.isRouteStop()) {
            if (log.isDebugEnabled()) {
                log.debug("ExchangeId: {} is marked to stop routing: {}", (Object)exchange.getExchangeId(), (Object)exchange);
            }
            return false;
        }
        return true;
    }
}

