/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.9.0", label="dataformat,transformation,security", title="PGP")
@XmlRootElement(name="pgp")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PGPDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String keyUserid;
    @XmlAttribute
    private String signatureKeyUserid;
    @XmlAttribute
    private String password;
    @XmlAttribute
    private String signaturePassword;
    @XmlAttribute
    private String keyFileName;
    @XmlAttribute
    private String signatureKeyFileName;
    @XmlAttribute
    private String signatureKeyRing;
    @XmlAttribute
    @Metadata(defaultValue="false", javaType="java.lang.Boolean")
    private String armored;
    @XmlAttribute
    @Metadata(defaultValue="true", javaType="java.lang.Boolean")
    private String integrity;
    @XmlAttribute
    private String provider;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String algorithm;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String compressionAlgorithm;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String hashAlgorithm;
    @XmlAttribute
    private String signatureVerificationOption;

    public PGPDataFormat() {
        super("pgp");
    }

    private PGPDataFormat(Builder builder) {
        this();
        this.keyUserid = builder.keyUserid;
        this.signatureKeyUserid = builder.signatureKeyUserid;
        this.password = builder.password;
        this.signaturePassword = builder.signaturePassword;
        this.keyFileName = builder.keyFileName;
        this.signatureKeyFileName = builder.signatureKeyFileName;
        this.signatureKeyRing = builder.signatureKeyRing;
        this.armored = builder.armored;
        this.integrity = builder.integrity;
        this.provider = builder.provider;
        this.algorithm = builder.algorithm;
        this.compressionAlgorithm = builder.compressionAlgorithm;
        this.hashAlgorithm = builder.hashAlgorithm;
        this.signatureVerificationOption = builder.signatureVerificationOption;
    }

    public String getSignatureKeyUserid() {
        return this.signatureKeyUserid;
    }

    public void setSignatureKeyUserid(String signatureKeyUserid) {
        this.signatureKeyUserid = signatureKeyUserid;
    }

    public String getSignaturePassword() {
        return this.signaturePassword;
    }

    public void setSignaturePassword(String signaturePassword) {
        this.signaturePassword = signaturePassword;
    }

    public String getSignatureKeyFileName() {
        return this.signatureKeyFileName;
    }

    public void setSignatureKeyFileName(String signatureKeyFileName) {
        this.signatureKeyFileName = signatureKeyFileName;
    }

    public String getSignatureKeyRing() {
        return this.signatureKeyRing;
    }

    public void setSignatureKeyRing(String signatureKeyRing) {
        this.signatureKeyRing = signatureKeyRing;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getArmored() {
        return this.armored;
    }

    public void setArmored(String armored) {
        this.armored = armored;
    }

    public String getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(String integrity) {
        this.integrity = integrity;
    }

    public String getKeyFileName() {
        return this.keyFileName;
    }

    public void setKeyFileName(String keyFileName) {
        this.keyFileName = keyFileName;
    }

    public String getKeyUserid() {
        return this.keyUserid;
    }

    public void setKeyUserid(String keyUserid) {
        this.keyUserid = keyUserid;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(String compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getSignatureVerificationOption() {
        return this.signatureVerificationOption;
    }

    public void setSignatureVerificationOption(String signatureVerificationOption) {
        this.signatureVerificationOption = signatureVerificationOption;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<PGPDataFormat> {
        private String keyUserid;
        private String signatureKeyUserid;
        private String password;
        private String signaturePassword;
        private String keyFileName;
        private String signatureKeyFileName;
        private String signatureKeyRing;
        private String armored;
        private String integrity;
        private String provider;
        private String algorithm;
        private String compressionAlgorithm;
        private String hashAlgorithm;
        private String signatureVerificationOption;

        public Builder signatureKeyUserid(String signatureKeyUserid) {
            this.signatureKeyUserid = signatureKeyUserid;
            return this;
        }

        public Builder signaturePassword(String signaturePassword) {
            this.signaturePassword = signaturePassword;
            return this;
        }

        public Builder signatureKeyFileName(String signatureKeyFileName) {
            this.signatureKeyFileName = signatureKeyFileName;
            return this;
        }

        public Builder signatureKeyRing(String signatureKeyRing) {
            this.signatureKeyRing = signatureKeyRing;
            return this;
        }

        public Builder hashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        public Builder hashAlgorithm(int hashAlgorithm) {
            this.hashAlgorithm = Integer.toString(hashAlgorithm);
            return this;
        }

        public Builder armored(String armored) {
            this.armored = armored;
            return this;
        }

        public Builder armored(boolean armored) {
            this.armored = Boolean.toString(armored);
            return this;
        }

        public Builder integrity(String integrity) {
            this.integrity = integrity;
            return this;
        }

        public Builder integrity(boolean integrity) {
            this.integrity = Boolean.toString(integrity);
            return this;
        }

        public Builder keyFileName(String keyFileName) {
            this.keyFileName = keyFileName;
            return this;
        }

        public Builder keyUserid(String keyUserid) {
            this.keyUserid = keyUserid;
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder algorithm(int algorithm) {
            this.algorithm = Integer.toString(algorithm);
            return this;
        }

        public Builder compressionAlgorithm(String compressionAlgorithm) {
            this.compressionAlgorithm = compressionAlgorithm;
            return this;
        }

        public Builder compressionAlgorithm(int compressionAlgorithm) {
            this.compressionAlgorithm = Integer.toString(compressionAlgorithm);
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder signatureVerificationOption(String signatureVerificationOption) {
            this.signatureVerificationOption = signatureVerificationOption;
            return this;
        }

        @Override
        public PGPDataFormat end() {
            return new PGPDataFormat(this);
        }
    }
}

