/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml.util.jsse;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.core.xml.util.jsse.AbstractJsseUtilFactoryBean;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.jsse.KeyStoreParameters;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractKeyStoreParametersFactoryBean
extends AbstractJsseUtilFactoryBean<KeyStoreParameters> {
    @XmlAttribute
    @Metadata(description="The optional type of the key store to load. See Appendix A in the Java Cryptography Architecture Standard Algorithm Name Documentation for more information on standard names.")
    protected String type;
    @XmlAttribute
    @Metadata(description="The optional password for reading/opening/verifying the key store")
    protected String password;
    @XmlAttribute
    @Metadata(description="The optional provider identifier for instantiating the key store")
    protected String provider;
    @XmlAttribute
    @Metadata(description="The optional file path, class path resource, or URL of the resource used to load the key store")
    protected String resource;
    @XmlTransient
    private KeyStoreParameters instance;

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String value) {
        this.resource = value;
    }

    @Override
    public KeyStoreParameters getObject() throws Exception {
        if (this.isSingleton()) {
            if (this.instance == null) {
                this.instance = this.createInstance();
            }
            return this.instance;
        }
        return this.createInstance();
    }

    protected KeyStoreParameters createInstance() {
        KeyStoreParameters newInstance = new KeyStoreParameters();
        newInstance.setPassword(this.password);
        newInstance.setProvider(this.provider);
        newInstance.setResource(this.resource);
        newInstance.setType(this.type);
        newInstance.setCamelContext(this.getCamelContext());
        return newInstance;
    }

    @Override
    public Class<? extends KeyStoreParameters> getObjectType() {
        return KeyStoreParameters.class;
    }
}

