/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.SetHeadersDefinition;
import org.apache.camel.processor.SetHeadersProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.support.LanguageSupport;

public class SetHeadersReifier
extends ProcessorReifier<SetHeadersDefinition> {
    public SetHeadersReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (SetHeadersDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        if (((SetHeadersDefinition)this.definition).getHeaders().isEmpty()) {
            throw new IllegalArgumentException("There must be at least one header specified");
        }
        ArrayList<Expression> nameExprs = new ArrayList<Expression>(((SetHeadersDefinition)this.definition).getHeaders().size());
        ArrayList<Expression> valueExprs = new ArrayList<Expression>(((SetHeadersDefinition)this.definition).getHeaders().size());
        for (SetHeaderDefinition hdrDef : ((SetHeadersDefinition)this.definition).getHeaders()) {
            valueExprs.add(this.createExpression(hdrDef.getExpression()));
            String key = this.parseString(hdrDef.getName());
            Expression nameExpr = LanguageSupport.hasSimpleFunction((String)key) ? this.camelContext.resolveLanguage("simple").createExpression(key) : this.camelContext.resolveLanguage("constant").createExpression(key);
            nameExpr.init(this.camelContext);
            nameExprs.add(nameExpr);
        }
        return new SetHeadersProcessor(nameExprs, valueExprs);
    }
}

