/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.BeanScope;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="eip,endpoint")
@XmlRootElement(name="bean")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BeanDefinition
extends NoOutputDefinition<BeanDefinition> {
    @XmlTransient
    private Class<?> beanClass;
    @XmlTransient
    private Object bean;
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private String method;
    @XmlAttribute
    private String beanType;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="Singleton", enums="Singleton,Request,Prototype")
    private String scope;

    public BeanDefinition() {
    }

    public BeanDefinition(String ref) {
        this.ref = ref;
    }

    public BeanDefinition(String ref, String method) {
        this.ref = ref;
        this.method = method;
    }

    public String toString() {
        return "Bean[" + this.description() + "]";
    }

    public String description() {
        if (this.ref != null) {
            Object methodText = "";
            if (this.method != null) {
                methodText = " method:" + this.method;
            }
            return "ref:" + this.ref + (String)methodText;
        }
        if (this.bean != null) {
            return ObjectHelper.className((Object)this.bean);
        }
        if (this.beanClass != null) {
            return this.beanClass.getName();
        }
        if (this.beanType != null) {
            return this.beanType;
        }
        return "";
    }

    public String getShortName() {
        return "bean";
    }

    @Override
    public String getLabel() {
        return "bean[" + this.description() + "]";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public String getBeanType() {
        return this.beanType;
    }

    public void setBeanType(String beanType) {
        this.beanType = beanType;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanClass = beanType;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setScope(BeanScope scope) {
        this.scope = scope.name();
    }
}

